/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.element;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.TextElementBuilder;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedOverlayElementBase;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class TextWindowElement
extends AnimatedOverlayElementBase {
    public static final Couple<Color> COLOR_WINDOW_BORDER = Couple.create(new Color(1618632704, true), new Color(544890880, true)).map(Color::setImmutable);
    Supplier<String> textGetter = () -> "(?) No text was provided";
    @Nullable
    String bakedText;
    int y;
    @Nullable
    class_243 vec;
    boolean nearScene = false;
    PonderPalette palette = PonderPalette.WHITE;

    public TextElementBuilder builder(PonderScene scene) {
        return new Builder(scene);
    }

    @Override
    public void render(PonderScene scene, PonderUI screen, class_332 graphics, float partialTicks, float fade) {
        if (this.bakedText == null) {
            this.bakedText = this.textGetter.get();
        }
        if (fade < 0.0625f) {
            return;
        }
        PonderScene.SceneTransform transform = scene.getTransform();
        class_241 sceneToScreen = this.vec != null ? transform.sceneToScreen(this.vec, partialTicks) : new class_241((float)screen.field_22789 / 2.0f, (float)(screen.field_22790 - 200) / 2.0f + (float)this.y - 8.0f);
        boolean settled = transform.xRotation.settled() && transform.yRotation.settled();
        float pY = settled ? (float)((int)sceneToScreen.field_1342) : sceneToScreen.field_1342;
        float yDiff = ((float)screen.field_22790 / 2.0f - sceneToScreen.field_1342 - 10.0f) / 100.0f;
        float targetX = (float)screen.field_22789 * class_3532.method_16439((float)(yDiff * yDiff), (float)0.75f, (float)0.625f);
        if (this.nearScene) {
            targetX = Math.min(targetX, sceneToScreen.field_1343 + 50.0f);
        }
        if (settled) {
            targetX = (int)targetX;
        }
        int textWidth = (int)Math.min((float)screen.field_22789 - targetX, 180.0f);
        class_327 fontRenderer = screen.getFontRenderer();
        List lines = fontRenderer.method_27527().method_27498(this.bakedText, textWidth, class_2583.field_24360);
        int boxWidth = 0;
        for (class_5348 line : lines) {
            boxWidth = Math.max(boxWidth, fontRenderer.method_27525(line));
        }
        int boxHeight = fontRenderer.method_1713(this.bakedText, boxWidth);
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(0.0f, pY);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(COLOR_WINDOW_BORDER)).at(targetX - 10.0f, 3.0f, -101.0f).withBounds(boxWidth, boxHeight - 1).render(graphics);
        Color brighter = this.palette.getColorObject().mixWith(new Color(-35), 0.5f).setImmutable();
        Color c1 = new Color(-11974327);
        Color c2 = new Color(-13027015);
        if (this.vec != null) {
            poseStack.pushMatrix();
            poseStack.translate(sceneToScreen.field_1343, 0.0f);
            double lineTarget = (targetX - sceneToScreen.field_1343) * fade;
            poseStack.scale((float)lineTarget, 1.0f);
            graphics.method_25296(0, 0, 1, 1, brighter.getRGB(), brighter.getRGB());
            graphics.method_25296(0, 1, 1, 2, c1.getRGB(), c2.getRGB());
            poseStack.popMatrix();
        }
        for (int i = 0; i < lines.size(); ++i) {
            graphics.method_51433(fontRenderer, ((class_5348)lines.get(i)).getString(), (int)(targetX - 10.0f), 3 + 9 * i, brighter.scaleAlphaForText(fade).getRGB(), false);
        }
        poseStack.popMatrix();
    }

    public PonderPalette getPalette() {
        return this.palette;
    }

    @Environment(value=EnvType.CLIENT)
    private class Builder
    implements TextElementBuilder {
        private final PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        @Override
        public Builder colored(PonderPalette color) {
            TextWindowElement.this.palette = color;
            return this;
        }

        @Override
        public Builder pointAt(class_243 vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        @Override
        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        @Override
        public Builder text(String defaultText) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText);
            return this;
        }

        @Override
        public Builder sharedText(class_2960 key) {
            TextWindowElement.this.textGetter = () -> PonderIndex.getLangAccess().getShared(key);
            return this;
        }

        @Override
        public Builder sharedText(String key) {
            return this.sharedText(class_2960.method_60655((String)this.scene.getNamespace(), (String)key));
        }

        @Override
        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        @Override
        public Builder attachKeyFrame() {
            this.scene.builder().addLazyKeyframe();
            return this;
        }
    }
}

