/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crafter;

import com.google.common.base.Predicates;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.crafter.CrafterHelper;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1851;
import net.minecraft.class_1863;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;

public class RecipeGridHandler {
    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChain(MechanicalCrafterBlockEntity root) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, (Predicate<MechanicalCrafterBlockEntity>)Predicates.alwaysTrue());
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(MechanicalCrafterBlockEntity root, Predicate<MechanicalCrafterBlockEntity> test) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, test, false);
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(MechanicalCrafterBlockEntity root, Predicate<MechanicalCrafterBlockEntity> test, boolean poweredStart) {
        ArrayList<MechanicalCrafterBlockEntity> crafters = new ArrayList<MechanicalCrafterBlockEntity>();
        ArrayList<Pair<MechanicalCrafterBlockEntity, Object>> frontier = new ArrayList<Pair<MechanicalCrafterBlockEntity, Object>>();
        HashSet<MechanicalCrafterBlockEntity> visited = new HashSet<MechanicalCrafterBlockEntity>();
        frontier.add(Pair.of(root, null));
        boolean empty = false;
        boolean allEmpty = true;
        while (!frontier.isEmpty()) {
            Pair pair = (Pair)frontier.removeFirst();
            MechanicalCrafterBlockEntity current = (MechanicalCrafterBlockEntity)pair.getFirst();
            MechanicalCrafterBlockEntity last = (MechanicalCrafterBlockEntity)pair.getSecond();
            if (visited.contains(current)) {
                return null;
            }
            if (!test.test(current)) {
                empty = true;
            } else {
                allEmpty = false;
            }
            crafters.add(current);
            visited.add(current);
            MechanicalCrafterBlockEntity target = RecipeGridHandler.getTargetingCrafter(current);
            if (target != last && target != null) {
                frontier.add(Pair.of(target, current));
            }
            for (MechanicalCrafterBlockEntity preceding : RecipeGridHandler.getPrecedingCrafters(current)) {
                if (preceding == last) continue;
                frontier.add(Pair.of(preceding, current));
            }
        }
        return empty && !poweredStart || allEmpty ? null : crafters;
    }

    public static MechanicalCrafterBlockEntity getTargetingCrafter(MechanicalCrafterBlockEntity crafter) {
        class_2680 state = crafter.method_11010();
        if (!RecipeGridHandler.isCrafter(state)) {
            return null;
        }
        class_2338 targetPos = crafter.method_11016().method_10093(MechanicalCrafterBlock.getTargetDirection(state));
        MechanicalCrafterBlockEntity targetBE = CrafterHelper.getCrafter((class_1920)crafter.method_10997(), targetPos);
        if (targetBE == null) {
            return null;
        }
        class_2680 targetState = targetBE.method_11010();
        if (!RecipeGridHandler.isCrafter(targetState)) {
            return null;
        }
        if (state.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING) != targetState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return null;
        }
        return targetBE;
    }

    public static List<MechanicalCrafterBlockEntity> getPrecedingCrafters(MechanicalCrafterBlockEntity crafter) {
        class_2338 pos = crafter.method_11016();
        class_1937 world = crafter.method_10997();
        ArrayList<MechanicalCrafterBlockEntity> crafters = new ArrayList<MechanicalCrafterBlockEntity>();
        class_2680 blockState = crafter.method_11010();
        if (!RecipeGridHandler.isCrafter(blockState)) {
            return crafters;
        }
        class_2350 blockFacing = (class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
        class_2350 blockPointing = MechanicalCrafterBlock.getTargetDirection(blockState);
        for (class_2350 facing : Iterate.directions) {
            MechanicalCrafterBlockEntity be;
            class_2338 neighbourPos;
            class_2680 neighbourState;
            if (blockFacing.method_10166() == facing.method_10166() || blockPointing == facing || !RecipeGridHandler.isCrafter(neighbourState = world.method_8320(neighbourPos = pos.method_10093(facing))) || MechanicalCrafterBlock.getTargetDirection(neighbourState) != facing.method_10153() || blockFacing != neighbourState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING) || (be = CrafterHelper.getCrafter((class_1920)world, neighbourPos)) == null) continue;
            crafters.add(be);
        }
        return crafters;
    }

    private static boolean isCrafter(class_2680 state) {
        return state.method_27852((class_2248)AllBlocks.MECHANICAL_CRAFTER);
    }

    public static class_1799 tryToApplyRecipe(class_3218 world, GroupedItems items) {
        items.calcStats();
        class_9694 craftingInput = items.toCraftingInput();
        class_1799 result = null;
        class_5455 registryAccess = world.method_30349();
        class_1863 recipeManager = world.method_64577();
        if (((Boolean)AllConfigs.server().recipes.allowRegularCraftingInCrafter.get()).booleanValue()) {
            result = recipeManager.field_54638.method_64699(class_3956.field_17545, (class_9695)craftingInput, (class_1937)world).filter(r -> RecipeGridHandler.isRecipeAllowed((class_8786<class_3955>)r, craftingInput)).findFirst().map(r -> ((class_3955)r.comp_1933()).method_8116((class_9695)craftingInput, (class_7225.class_7874)registryAccess)).orElse(null);
        }
        if (result == null) {
            result = recipeManager.method_8132(AllRecipeTypes.MECHANICAL_CRAFTING, (class_9695)craftingInput, (class_1937)world).map(r -> ((MechanicalCraftingRecipe)r.comp_1933()).craft(craftingInput, (class_7225.class_7874)registryAccess)).orElse(null);
        }
        return result;
    }

    public static boolean isRecipeAllowed(class_8786<class_3955> recipe, class_9694 craftingInput) {
        if (recipe.comp_1933() instanceof class_1851) {
            int numItems = 0;
            for (int i = 0; i < craftingInput.method_59983(); ++i) {
                if (craftingInput.method_59984(i).method_7960()) continue;
                ++numItems;
            }
            if (numItems > (Integer)AllConfigs.server().recipes.maxFireworkIngredientsInCrafter.get()) {
                return false;
            }
        }
        return !AllRecipeTypes.shouldIgnoreInAutomation(recipe);
    }

    public static class GroupedItems {
        public static final Codec<Map<Pair<Integer, Integer>, class_1799>> GRID_CODEC = CreateCodecs.getCodecMap(Pair.codec(Codec.INT, Codec.INT), class_1799.field_49266);
        public static final Codec<GroupedItems> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GRID_CODEC.fieldOf("Grid").forGetter(i -> i.grid)).apply((Applicative)instance, GroupedItems::new));
        public Map<Pair<Integer, Integer>, class_1799> grid = new HashMap<Pair<Integer, Integer>, class_1799>();
        public int minX;
        public int minY;
        int maxX;
        int maxY;
        public int width;
        public int height;
        boolean statsReady;

        public GroupedItems() {
        }

        public GroupedItems(class_1799 stack) {
            this.grid.put(Pair.of(0, 0), stack);
        }

        public GroupedItems(Map<Pair<Integer, Integer>, class_1799> grid) {
            this.grid.putAll(grid);
        }

        public void mergeOnto(GroupedItems other, Pointing pointing) {
            int xOffset;
            int n = pointing == Pointing.LEFT ? 1 : (xOffset = pointing == Pointing.RIGHT ? -1 : 0);
            int yOffset = pointing == Pointing.DOWN ? 1 : (pointing == Pointing.UP ? -1 : 0);
            this.grid.forEach((pair, stack) -> other.grid.put(Pair.of((Integer)pair.getFirst() + xOffset, (Integer)pair.getSecond() + yOffset), (class_1799)stack));
            other.statsReady = false;
        }

        public void write(class_11372 view) {
            class_11372.class_11374 list = view.method_71476("Grid");
            this.grid.forEach((pair, stack) -> {
                class_11372 entry = list.method_71480();
                entry.method_71465("x", ((Integer)pair.getFirst()).intValue());
                entry.method_71465("y", ((Integer)pair.getSecond()).intValue());
                entry.method_71468("item", class_1799.field_49266, stack);
            });
        }

        public static GroupedItems read(class_11368 view) {
            GroupedItems items = new GroupedItems();
            class_11368.class_11370 list = view.method_71438("Grid");
            list.forEach(entry -> {
                int x = entry.method_71424("x", 0);
                int y = entry.method_71424("y", 0);
                class_1799 stack = entry.method_71426("item", class_1799.field_49266).orElse(class_1799.field_8037);
                items.grid.put(Pair.of(x, y), stack);
            });
            return items;
        }

        public void calcStats() {
            if (this.statsReady) {
                return;
            }
            this.statsReady = true;
            this.minX = 0;
            this.minY = 0;
            this.maxX = 0;
            this.maxY = 0;
            for (Pair<Integer, Integer> pair : this.grid.keySet()) {
                int x = pair.getFirst();
                int y = pair.getSecond();
                this.minX = Math.min(this.minX, x);
                this.minY = Math.min(this.minY, y);
                this.maxX = Math.max(this.maxX, x);
                this.maxY = Math.max(this.maxY, y);
            }
            this.width = this.maxX - this.minX + 1;
            this.height = this.maxY - this.minY + 1;
        }

        public boolean onlyEmptyItems() {
            for (class_1799 stack : this.grid.values()) {
                if (stack.method_7960()) continue;
                return false;
            }
            return true;
        }

        public class_9694 toCraftingInput() {
            class_1799 stack;
            ArrayList<class_1799> list = new ArrayList<class_1799>(this.width * this.height);
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int xp = x + this.minX;
                    int yp = y + this.minY;
                    stack = this.grid.get(Pair.of(xp, yp));
                    if (stack == null || stack.method_7960()) continue;
                    minX = Math.min(minX, xp);
                    maxX = Math.max(maxX, xp);
                    minY = Math.min(minY, yp);
                    maxY = Math.max(maxY, yp);
                }
            }
            int w = maxX - minX + 1;
            int h = maxY - minY + 1;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    stack = this.grid.get(Pair.of(x + minX, maxY - y));
                    list.add(stack == null ? class_1799.field_8037 : stack.method_7972());
                }
            }
            return new class_9694(w, h, list);
        }
    }
}

