/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.filter;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.filter.AttributeFilterMenu;
import com.zurrtum.create.content.logistics.filter.FilterMenu;
import com.zurrtum.create.content.logistics.filter.PackageFilterMenu;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.ItemCopyingRecipe;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.ItemAttributeEntry;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5244;
import net.minecraft.class_9129;
import net.minecraft.class_9288;
import net.minecraft.class_9331;
import net.minecraft.class_9336;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterItem
extends class_1792
implements MenuProvider,
ItemCopyingRecipe.SupportsItemCopying {
    private final FilterType type;

    public static FilterItem regular(class_1792.class_1793 properties) {
        return new FilterItem(FilterType.REGULAR, properties);
    }

    public static FilterItem attribute(class_1792.class_1793 properties) {
        return new FilterItem(FilterType.ATTRIBUTE, properties);
    }

    public static FilterItem address(class_1792.class_1793 properties) {
        return new FilterItem(FilterType.PACKAGE, properties);
    }

    private FilterItem(FilterType type, class_1792.class_1793 properties) {
        super(properties);
        this.type = type;
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() == null) {
            return class_1269.field_5811;
        }
        return this.method_7836(context.method_8045(), context.method_8036(), context.method_20287());
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        if (AllClientHandle.INSTANCE.shiftDown()) {
            return;
        }
        List<class_2561> makeSummary = this.makeSummary(stack);
        if (makeSummary.isEmpty()) {
            return;
        }
        textConsumer.accept(class_5244.field_41874);
        makeSummary.forEach(textConsumer);
    }

    private List<class_2561> makeSummary(class_1799 filter) {
        String address;
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        if (filter.method_57380().method_57848()) {
            return list;
        }
        if (this.type == FilterType.REGULAR) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean blacklist = (Boolean)filter.method_58695(AllDataComponents.FILTER_ITEMS_BLACKLIST, (Object)false);
            list.add((class_2561)(blacklist ? class_2561.method_43471((String)"create.gui.filter.deny_list") : class_2561.method_43471((String)"create.gui.filter.allow_list")).method_27692(class_124.field_1065));
            int count = 0;
            int size = filterItems.method_5439();
            for (int i = 0; i < size; ++i) {
                if (count > 3) {
                    list.add((class_2561)class_2561.method_43470((String)"- ...").method_27692(class_124.field_1063));
                    break;
                }
                class_1799 filterStack = filterItems.method_5438(i);
                if (filterStack.method_7960()) continue;
                list.add((class_2561)class_2561.method_43470((String)"- ").method_10852(filterStack.method_7964()).method_27692(class_124.field_1080));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        if (this.type == FilterType.ATTRIBUTE) {
            AttributeFilterWhitelistMode whitelistMode = (AttributeFilterWhitelistMode)((Object)filter.method_58694(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE));
            list.add((class_2561)(whitelistMode == AttributeFilterWhitelistMode.WHITELIST_CONJ ? class_2561.method_43471((String)"create.gui.attribute_filter.allow_list_conjunctive") : (whitelistMode == AttributeFilterWhitelistMode.WHITELIST_DISJ ? class_2561.method_43471((String)"create.gui.attribute_filter.allow_list_disjunctive") : class_2561.method_43471((String)"create.gui.attribute_filter.deny_list"))).method_27692(class_124.field_1065));
            int count = 0;
            List attributes = (List)filter.method_58695(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, new ArrayList());
            for (ItemAttributeEntry attributeEntry : attributes) {
                ItemAttribute attribute = attributeEntry.attribute();
                if (attribute == null) continue;
                boolean inverted = attributeEntry.inverted();
                if (count > 3) {
                    list.add((class_2561)class_2561.method_43470((String)"- ...").method_27692(class_124.field_1063));
                    break;
                }
                list.add((class_2561)class_2561.method_43470((String)"- ").method_10852((class_2561)attribute.format(inverted)));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        if (this.type == FilterType.PACKAGE && !(address = PackageItem.getAddress(filter)).isBlank()) {
            list.add((class_2561)class_2561.method_43470((String)"-> ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)address).method_27692(class_124.field_1065)));
        }
        return list;
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!player.method_5715() && hand == class_1268.field_5808) {
            if (!world.field_9236 && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.openHandledScreen(serverPlayer);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    @Nullable
    public MenuBase<?> createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        class_1799 heldItem = player.method_6047();
        class_1799.field_48349.encode((Object)extraData, (Object)heldItem);
        if (this.type == FilterType.REGULAR) {
            return new FilterMenu(id, inv, heldItem);
        }
        if (this.type == FilterType.ATTRIBUTE) {
            return new AttributeFilterMenu(id, inv, heldItem);
        }
        if (this.type == FilterType.PACKAGE) {
            return new PackageFilterMenu(id, inv, heldItem);
        }
        return null;
    }

    @Override
    public class_2561 method_5476() {
        return this.method_63680();
    }

    public static ItemStackHandler getFilterItems(class_1799 stack) {
        ItemStackHandler newInv = new ItemStackHandler(18);
        if (AllItems.FILTER != stack.method_7909()) {
            throw new IllegalArgumentException("Cannot get filter items from non-filter: " + String.valueOf(stack));
        }
        if (!stack.method_57826(AllDataComponents.FILTER_ITEMS)) {
            return newInv;
        }
        ItemHelper.fillItemStackHandler((class_9288)stack.method_58694(AllDataComponents.FILTER_ITEMS), newInv);
        return newInv;
    }

    public static boolean testDirect(class_1799 filter, class_1799 stack, boolean matchNBT) {
        if (matchNBT) {
            if (PackageItem.isPackage(filter) && PackageItem.isPackage(stack)) {
                return FilterItem.doPackagesHaveSameData(filter, stack);
            }
            return class_1799.method_31577((class_1799)filter, (class_1799)stack);
        }
        if (PackageItem.isPackage(filter) && PackageItem.isPackage(stack)) {
            return true;
        }
        return ItemHelper.sameItem(filter, stack);
    }

    public static boolean doPackagesHaveSameData(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (a.method_7960()) {
            return false;
        }
        if (!class_1799.method_31577((class_1799)a, (class_1799)b)) {
            return false;
        }
        for (class_9336 component : a.method_57353()) {
            class_9331 type = component.comp_2443();
            if (type.equals(AllDataComponents.PACKAGE_ORDER_DATA) || type.equals(AllDataComponents.PACKAGE_ORDER_CONTEXT) || Objects.equals(a.method_58694(type), b.method_58694(type))) continue;
            return false;
        }
        return true;
    }

    @Override
    public class_9331<?> getComponentType() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES;
            case 2 -> AllDataComponents.PACKAGE_ADDRESS;
            case 0 -> AllDataComponents.FILTER_ITEMS;
        };
    }

    private static enum FilterType {
        REGULAR,
        ATTRIBUTE,
        PACKAGE;

    }
}

