/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.stockTicker;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.zurrtum.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperCategoryMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4844;
import net.minecraft.class_9129;

public class StockTickerBlockEntity
extends StockCheckingBlockEntity {
    public static final Codec<Map<UUID, List<Integer>>> UUID_MAP_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)Codec.INT.listOf());
    public List<List<BigItemStack>> lastClientsideStockSnapshot;
    protected InventorySummary lastClientsideStockSnapshotAsSummary;
    protected List<BigItemStack> newlyReceivedStockSnapshot;
    public String previouslyUsedAddress = "";
    public int activeLinks;
    public int ticksSinceLastUpdate;
    public List<class_1799> categories;
    public Map<UUID, List<Integer>> hiddenCategoriesByPlayer;
    public StockTickerInventory receivedPayments = new StockTickerInventory();

    public StockTickerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.STOCK_TICKER, pos, state);
        this.categories = new ArrayList<class_1799>();
        this.hiddenCategoriesByPlayer = new HashMap<UUID, List<Integer>>();
    }

    public void resetTicksSinceLastUpdate() {
        this.ticksSinceLastUpdate = 0;
    }

    public class_1263 getReceivedPaymentsHandler() {
        return this.receivedPayments;
    }

    public List<List<BigItemStack>> getClientStockSnapshot() {
        return this.lastClientsideStockSnapshot;
    }

    public InventorySummary getLastClientsideStockSnapshotAsSummary() {
        return this.lastClientsideStockSnapshotAsSummary;
    }

    public int getTicksSinceLastUpdate() {
        return this.ticksSinceLastUpdate;
    }

    @Override
    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, PackageOrderWithCrafts order, IdentifiedInventory ignoredHandler, String address) {
        boolean result = super.broadcastPackageRequest(type, order, ignoredHandler, address);
        this.previouslyUsedAddress = address;
        this.notifyUpdate();
        return result;
    }

    @Override
    public InventorySummary getRecentSummary() {
        InventorySummary recentSummary = super.getRecentSummary();
        int contributingLinks = recentSummary.contributingLinks;
        if (this.activeLinks != contributingLinks && !this.method_11015()) {
            this.activeLinks = contributingLinks;
            this.sendData();
        }
        return recentSummary;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236 && this.ticksSinceLastUpdate < 100) {
            ++this.ticksSinceLastUpdate;
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71469("PreviousAddress", this.previouslyUsedAddress);
        this.receivedPayments.write(view);
        view.method_71468("Categories", CreateCodecs.ITEM_LIST_CODEC, this.categories);
        view.method_71468("HiddenCategories", UUID_MAP_CODEC, this.hiddenCategoriesByPlayer);
        if (clientPacket) {
            view.method_71465("ActiveLinks", this.activeLinks);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.previouslyUsedAddress = view.method_71428("PreviousAddress", "");
        this.receivedPayments.read(view);
        this.categories.clear();
        view.method_71426("Categories", CreateCodecs.ITEM_LIST_CODEC).ifPresent(list -> list.forEach(stack -> {
            if (!stack.method_7960() && !(stack.method_7909() instanceof FilterItem)) {
                return;
            }
            this.categories.add((class_1799)stack);
        }));
        this.hiddenCategoriesByPlayer.clear();
        view.method_71426("HiddenCategories", UUID_MAP_CODEC).ifPresent(map -> this.hiddenCategoriesByPlayer.putAll((Map<UUID, List<Integer>>)map));
        if (clientPacket) {
            this.activeLinks = view.method_71424("ActiveLinks", 0);
        }
    }

    public void receiveStockPacket(List<BigItemStack> stacks, boolean endOfTransmission) {
        if (this.newlyReceivedStockSnapshot == null) {
            this.newlyReceivedStockSnapshot = new ArrayList<BigItemStack>();
        }
        this.newlyReceivedStockSnapshot.addAll(stacks);
        if (!endOfTransmission) {
            return;
        }
        this.lastClientsideStockSnapshotAsSummary = new InventorySummary();
        this.lastClientsideStockSnapshot = new ArrayList<List<BigItemStack>>();
        for (BigItemStack bigStack : this.newlyReceivedStockSnapshot) {
            this.lastClientsideStockSnapshotAsSummary.add(bigStack);
        }
        for (class_1799 filter : this.categories) {
            ArrayList<BigItemStack> inCategory = new ArrayList<BigItemStack>();
            if (!filter.method_7960()) {
                FilterItemStack filterItemStack = FilterItemStack.of(filter);
                Iterator<BigItemStack> iterator = this.newlyReceivedStockSnapshot.iterator();
                while (iterator.hasNext()) {
                    BigItemStack bigStack = iterator.next();
                    if (!filterItemStack.test(this.field_11863, bigStack.stack)) continue;
                    inCategory.add(bigStack);
                    iterator.remove();
                }
            }
            this.lastClientsideStockSnapshot.add(inCategory);
        }
        ArrayList<BigItemStack> unsorted = new ArrayList<BigItemStack>(this.newlyReceivedStockSnapshot);
        this.lastClientsideStockSnapshot.add(unsorted);
        this.newlyReceivedStockSnapshot = null;
    }

    public boolean isKeeperPresent() {
        for (int yOffset : Iterate.zeroAndOne) {
            for (class_2350 side : Iterate.horizontalDirections) {
                class_2586 entity;
                class_2338 seatPos = this.field_11867.method_10087(yOffset).method_10093(side);
                int x = seatPos.method_10263();
                int y = seatPos.method_10264();
                int z = seatPos.method_10260();
                for (SeatEntity seatEntity : this.field_11863.method_18467(SeatEntity.class, new class_238((double)x, (double)((float)y - 0.1f), (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)))) {
                    if (!seatEntity.method_5782()) continue;
                    return true;
                }
                if (yOffset != 0 || (entity = this.field_11863.method_8321(seatPos)) == null || entity.method_11017() != AllBlockEntityTypes.HEATER) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void destroy() {
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this.receivedPayments);
        int x = this.field_11867.method_10263();
        int y = this.field_11867.method_10264();
        int z = this.field_11867.method_10260();
        for (class_1799 filter : this.categories) {
            if (filter.method_7960() || !(filter.method_7909() instanceof FilterItem)) continue;
            class_1264.method_5449((class_1937)this.field_11863, (double)x, (double)y, (double)z, (class_1799)filter);
        }
        super.destroy();
    }

    public void playEffect() {
        AllSoundEvents.STOCK_LINK.playAt(this.field_11863, (class_2382)this.field_11867, 1.0f, 1.0f, false);
        class_243 vec3 = class_243.method_24953((class_2382)this.field_11867);
        this.field_11863.method_8406((class_2394)AllParticleTypes.WIFI, vec3.field_1352, vec3.field_1351, vec3.field_1350, 1.0, 1.0, 1.0);
    }

    public StockKeeperCategoryMenu createCategoryMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer, class_9129 extraData) {
        extraData.method_10807(this.field_11867);
        return new StockKeeperCategoryMenu(pContainerId, pPlayerInventory, this);
    }

    public StockKeeperRequestMenu createRequestMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer, class_9129 extraData) {
        boolean showLockOption = this.behaviour.mayAdministrate(pPlayer) && Create.LOGISTICS.isLockable(this.behaviour.freqId);
        boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(this.behaviour.freqId);
        extraData.method_10807(this.field_11867);
        extraData.method_52964(showLockOption);
        extraData.method_52964(isCurrentlyLocked);
        return new StockKeeperRequestMenu(pContainerId, pPlayerInventory, this);
    }

    public class StockTickerInventory
    extends ItemStackHandler {
        public StockTickerInventory() {
            super(27);
        }

        @Override
        public void method_5431() {
            StockTickerBlockEntity.this.notifyUpdate();
        }
    }
}

