/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.impl.contraption.dispenser;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.zurrtum.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.zurrtum.create.api.contraption.dispenser.MountedProjectileDispenseBehavior;
import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public enum DispenserBehaviorConverter implements SimpleRegistry.Provider<class_1792, MountedDispenseBehavior>
{
    INSTANCE;


    @Override
    @Nullable
    public MountedDispenseBehavior get(class_1792 item, class_1937 world) {
        class_2357 vanilla = ((class_2315)class_2246.field_10200).method_10011(world, item.method_7854());
        if (vanilla == null) {
            return null;
        }
        if (vanilla.getClass() == class_2347.class) {
            return null;
        }
        if (item.method_40131().method_40220(AllItemTags.DISPENSE_BEHAVIOR_WRAP_BLACKLIST)) {
            return null;
        }
        if (vanilla instanceof class_2965) {
            class_2965 projectile = (class_2965)vanilla;
            return MountedProjectileDispenseBehavior.of(projectile);
        }
        return new FallbackBehavior(item, vanilla);
    }

    @Override
    @Nullable
    public MountedDispenseBehavior get(class_1792 item) {
        Create.LOGGER.warn("Requires World parameter");
        return null;
    }

    @Override
    public void onRegister(Runnable invalidate) {
    }

    private static final class FallbackBehavior
    extends DefaultMountedDispenseBehavior {
        private final class_1792 item;
        private final class_2357 wrapped;
        private boolean hasErrored;

        private FallbackBehavior(class_1792 item, class_2357 wrapped) {
            this.item = item;
            this.wrapped = wrapped;
        }

        @Override
        protected class_1799 execute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
            if (this.hasErrored) {
                return stack;
            }
            MinecraftServer server = context.world.method_8503();
            class_3218 serverLevel = server != null ? server.method_3847(context.world.method_27983()) : null;
            class_2350 nearestFacing = MountedDispenseBehavior.getClosestFacingDirection(facing);
            class_2680 state = context.state;
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)nearestFacing);
            }
            class_2342 source = new class_2342(serverLevel, pos, state, null);
            try {
                return this.wrapped.dispense(source, stack.method_7972());
            }
            catch (NullPointerException e) {
                class_2960 itemId = class_7923.field_41178.method_10221((Object)this.item);
                String message = "Error dispensing item '" + String.valueOf(itemId) + "' from contraption, not doing that anymore";
                Create.LOGGER.error(message, (Throwable)e);
                this.hasErrored = true;
                return stack;
            }
        }
    }
}

