/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.bearing;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.IControlContraption;
import com.zurrtum.create.content.contraptions.bearing.BearingBlock;
import com.zurrtum.create.content.contraptions.bearing.BearingContraption;
import com.zurrtum.create.content.contraptions.bearing.IBearingBlockEntity;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class MechanicalBearingBlockEntity
extends GeneratingKineticBlockEntity
implements IBearingBlockEntity {
    protected ServerScrollOptionBehaviour<IControlContraption.RotationMode> movementMode;
    protected ControlledContraptionEntity movedContraption;
    protected float angle;
    protected boolean running;
    protected boolean assembleNextTick;
    protected float clientAngleDiff;
    public AssemblyException lastException;
    protected double sequencedAngleLimit;
    private float prevAngle;

    public MechanicalBearingBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(3);
        this.sequencedAngleLimit = -1.0;
    }

    public MechanicalBearingBlockEntity(class_2338 pos, class_2680 state) {
        this(AllBlockEntityTypes.MECHANICAL_BEARING, pos, state);
    }

    @Override
    public boolean isWoodenTop() {
        return false;
    }

    @Override
    protected boolean syncSequenceContext() {
        return true;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.movementMode = new ServerScrollOptionBehaviour<IControlContraption.RotationMode>(IControlContraption.RotationMode.class, this);
        behaviours.add(this.movementMode);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void remove() {
        if (!this.field_11863.method_8608()) {
            this.disassemble();
        }
        super.remove();
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("Running", this.running);
        view.method_71464("Angle", this.angle);
        if (this.sequencedAngleLimit >= 0.0) {
            view.method_71463("SequencedAngleLimit", this.sequencedAngleLimit);
        }
        if (this.lastException != null) {
            view.method_71468("LastException", AssemblyException.CODEC, (Object)this.lastException);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        if (this.wasMoved) {
            super.read(view, clientPacket);
            return;
        }
        float angleBefore = this.angle;
        this.running = view.method_71433("Running", false);
        this.angle = view.method_71423("Angle", 0.0f);
        this.sequencedAngleLimit = view.method_71422("SequencedAngleLimit", -1.0);
        this.lastException = view.method_71426("LastException", AssemblyException.CODEC).orElse(null);
        super.read(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            if (this.movedContraption == null || !this.movedContraption.isStalled()) {
                this.clientAngleDiff = AngleHelper.getShortestAngleDiff(angleBefore, this.angle);
                this.angle = angleBefore;
            }
        } else {
            this.movedContraption = null;
        }
    }

    @Override
    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return class_3532.method_16439((float)(partialTicks + 0.5f), (float)this.prevAngle, (float)this.angle);
        }
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        float angularSpeed = this.getAngularSpeed();
        if (this.sequencedAngleLimit >= 0.0) {
            angularSpeed = (float)class_3532.method_15350((double)angularSpeed, (double)(-this.sequencedAngleLimit), (double)this.sequencedAngleLimit);
        }
        return class_3532.method_16439((float)partialTicks, (float)this.angle, (float)(this.angle + angularSpeed));
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
        this.sequencedAngleLimit = -1.0;
        if (this.movedContraption != null && Math.signum(prevSpeed) != Math.signum(this.getSpeed()) && prevSpeed != 0.0f) {
            if (!this.movedContraption.isStalled()) {
                this.angle = Math.round(this.angle);
                this.applyRotation();
            }
            this.movedContraption.getContraption().stop(this.field_11863);
        }
        if (!this.isWindmill() && this.sequenceContext != null && this.sequenceContext.instruction() == SequencerInstructions.TURN_ANGLE) {
            this.sequencedAngleLimit = this.sequenceContext.getEffectiveValue(this.getTheoreticalSpeed());
        }
    }

    public float getAngularSpeed() {
        float speed = MechanicalBearingBlockEntity.convertToAngular(this.isWindmill() ? this.getGeneratedSpeed() : this.getSpeed());
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        if (this.field_11863.method_8608()) {
            speed *= AllClientHandle.INSTANCE.getServerSpeed();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public boolean isWindmill() {
        return false;
    }

    public void assemble() {
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof BearingBlock)) {
            return;
        }
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)BearingBlock.FACING);
        BearingContraption contraption = new BearingContraption(this.isWindmill(), direction);
        try {
            if (!contraption.assemble(this.field_11863, this.field_11867)) {
                return;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (this.isWindmill()) {
            this.award(AllAdvancements.WINDMILL);
        }
        if (contraption.getSailBlocks() >= 128) {
            this.award(AllAdvancements.WINDMILL_MAXED);
        }
        contraption.removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
        this.movedContraption = ControlledContraptionEntity.create(this.field_11863, this, contraption);
        class_2338 anchor = this.field_11867.method_10093(direction);
        this.movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        this.movedContraption.setRotationAxis(direction.method_10166());
        this.field_11863.method_8649((class_1297)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        this.running = true;
        this.angle = 0.0f;
        this.sendData();
        this.updateGeneratedRotation();
    }

    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.angle = 0.0f;
        this.sequencedAngleLimit = -1.0;
        if (this.isWindmill()) {
            this.applyRotation();
        }
        if (this.movedContraption != null) {
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        }
        this.movedContraption = null;
        this.running = false;
        this.updateGeneratedRotation();
        this.assembleNextTick = false;
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.prevAngle = this.angle;
        if (this.field_11863.method_8608()) {
            this.clientAngleDiff /= 2.0f;
        }
        if (!this.field_11863.method_8608() && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                boolean canDisassemble;
                boolean bl = canDisassemble = this.movementMode.get() == IControlContraption.RotationMode.ROTATE_PLACE || this.isNearInitialAngle() && this.movementMode.get() == IControlContraption.RotationMode.ROTATE_PLACE_RETURNED;
                if (this.speed == 0.0f && (canDisassemble || this.movedContraption == null || this.movedContraption.getContraption().getBlocks().isEmpty())) {
                    if (this.movedContraption != null) {
                        this.movedContraption.getContraption().stop(this.field_11863);
                    }
                    this.disassemble();
                    return;
                }
            } else {
                if (this.speed == 0.0f && !this.isWindmill()) {
                    return;
                }
                this.assemble();
            }
        }
        if (!this.running) {
            return;
        }
        if (this.movedContraption == null || !this.movedContraption.isStalled()) {
            float angularSpeed = this.getAngularSpeed();
            if (this.sequencedAngleLimit >= 0.0) {
                angularSpeed = (float)class_3532.method_15350((double)angularSpeed, (double)(-this.sequencedAngleLimit), (double)this.sequencedAngleLimit);
                this.sequencedAngleLimit = Math.max(0.0, this.sequencedAngleLimit - (double)Math.abs(angularSpeed));
            }
            this.angle = (this.angle + angularSpeed) % 360.0f;
        }
        this.applyRotation();
    }

    public boolean isNearInitialAngle() {
        return (double)Math.abs(this.angle) < 22.5 || (double)Math.abs(this.angle) > 337.5;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && !this.field_11863.method_8608()) {
            this.sendData();
        }
    }

    protected void applyRotation() {
        if (this.movedContraption == null) {
            return;
        }
        this.movedContraption.setAngle(this.angle);
        class_2680 blockState = this.method_11010();
        if (blockState.method_28498((class_2769)class_2741.field_12525)) {
            this.movedContraption.setRotationAxis(((class_2350)blockState.method_11654((class_2769)class_2741.field_12525)).method_10166());
        }
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        class_2680 blockState = this.method_11010();
        if (!(contraption.getContraption() instanceof BearingContraption)) {
            return;
        }
        if (!blockState.method_28498((class_2769)BearingBlock.FACING)) {
            return;
        }
        this.movedContraption = contraption;
        this.method_5431();
        class_2338 anchor = this.field_11867.method_10093((class_2350)blockState.method_11654((class_2769)BearingBlock.FACING));
        this.movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        if (!this.field_11863.method_8608()) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void onStall() {
        if (!this.field_11863.method_8608()) {
            this.sendData();
        }
    }

    @Override
    public boolean isValid() {
        return !this.method_11015();
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setAngle(float forcedAngle) {
        this.angle = forcedAngle;
    }

    public ControlledContraptionEntity getMovedContraption() {
        return this.movedContraption;
    }

    @Override
    public class_2338 getBlockPosition() {
        return this.field_11867;
    }
}

