/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.math.VecHelper;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_2241;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_9878;
import net.minecraft.class_9883;

public class MinecartSim2020 {
    private static final Map<class_2768, Pair<class_2382, class_2382>> MATRIX = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2768.class), map -> {
        class_2382 west = class_2350.field_11039.method_62675();
        class_2382 east = class_2350.field_11034.method_62675();
        class_2382 north = class_2350.field_11043.method_62675();
        class_2382 south = class_2350.field_11035.method_62675();
        map.put(class_2768.field_12665, Pair.of((Object)north, (Object)south));
        map.put(class_2768.field_12674, Pair.of((Object)west, (Object)east));
        map.put(class_2768.field_12667, Pair.of((Object)west.method_23228(), (Object)east));
        map.put(class_2768.field_12666, Pair.of((Object)west, (Object)east.method_23228()));
        map.put(class_2768.field_12670, Pair.of((Object)north, (Object)south.method_23228()));
        map.put(class_2768.field_12668, Pair.of((Object)north.method_23228(), (Object)south));
        map.put(class_2768.field_12664, Pair.of((Object)south, (Object)east));
        map.put(class_2768.field_12671, Pair.of((Object)south, (Object)west));
        map.put(class_2768.field_12672, Pair.of((Object)north, (Object)west));
        map.put(class_2768.field_12663, Pair.of((Object)north, (Object)east));
    });

    public static class_243 predictNextPositionOf(class_1688 cart) {
        class_243 position = cart.method_73189();
        class_243 motion = VecHelper.clamp(cart.method_18798(), 1.0f);
        return position.method_1019(motion);
    }

    public static boolean canAddMotion(class_1688 c) {
        if (c instanceof class_1696) {
            class_1696 furnace = (class_1696)c;
            return class_3532.method_20390((double)furnace.field_54300.field_1352, (double)0.0) && class_3532.method_20390((double)furnace.field_54300.field_1350, (double)0.0);
        }
        return AllSynchedDatas.MINECART_CONTROLLER.get((class_1297)c).map(controller -> !controller.isStalled()).orElse(true);
    }

    public static void moveCartAlongTrack(class_3218 world, class_1688 cart, class_243 forcedMovement, class_2338 cartPos, class_2680 trackState) {
        double d14;
        if (forcedMovement.equals((Object)class_243.field_1353)) {
            return;
        }
        class_243 previousMotion = cart.method_18798();
        cart.field_6017 = 0.0;
        double x = cart.method_23317();
        double y = cart.method_23318();
        double z = cart.method_23321();
        double actualX = x;
        double actualY = y;
        double actualZ = z;
        class_9878 class_98782 = cart.method_61569();
        if (!(class_98782 instanceof class_9883)) {
            return;
        }
        class_9883 controller = (class_9883)class_98782;
        class_243 actualVec = controller.method_61620(actualX, actualY, actualZ);
        actualY = cartPos.method_10264() + 1;
        class_2241 abstractrailblock = (class_2241)trackState.method_26204();
        class_2768 railshape = (class_2768)trackState.method_11654(abstractrailblock.method_9474());
        switch (railshape) {
            case field_12667: {
                forcedMovement = forcedMovement.method_1031(-0.0078125, 0.0, 0.0);
                actualY += 1.0;
                break;
            }
            case field_12666: {
                forcedMovement = forcedMovement.method_1031(0.0078125, 0.0, 0.0);
                actualY += 1.0;
                break;
            }
            case field_12670: {
                forcedMovement = forcedMovement.method_1031(0.0, 0.0, 0.0078125);
                actualY += 1.0;
                break;
            }
            case field_12668: {
                forcedMovement = forcedMovement.method_1031(0.0, 0.0, -0.0078125);
                actualY += 1.0;
            }
        }
        Pair<class_2382, class_2382> pair = MATRIX.get(railshape);
        class_2382 Vector3i = (class_2382)pair.getFirst();
        class_2382 Vector3i1 = (class_2382)pair.getSecond();
        double d4 = Vector3i1.method_10263() - Vector3i.method_10263();
        double d5 = Vector3i1.method_10260() - Vector3i.method_10260();
        double d7 = forcedMovement.field_1352 * d4 + forcedMovement.field_1350 * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d23 = (double)cartPos.method_10263() + 0.5 + (double)Vector3i.method_10263() * 0.5;
        double d10 = (double)cartPos.method_10260() + 0.5 + (double)Vector3i.method_10260() * 0.5;
        double d12 = (double)cartPos.method_10263() + 0.5 + (double)Vector3i1.method_10263() * 0.5;
        double d13 = (double)cartPos.method_10260() + 0.5 + (double)Vector3i1.method_10260() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = actualZ - (double)cartPos.method_10260();
        } else if (d5 == 0.0) {
            d14 = actualX - (double)cartPos.method_10263();
        } else {
            double d15 = actualX - d23;
            double d16 = actualZ - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        actualX = d23 + d4 * d14;
        actualZ = d10 + d5 * d14;
        cart.method_5814(actualX, actualY, actualZ);
        cart.method_18799(forcedMovement);
        double s = cart.method_5782() ? 0.75 : 1.0;
        double t = controller.method_61598(world);
        class_243 vec3d2 = cart.method_18798();
        cart.method_5784(class_1313.field_6308, new class_243(class_3532.method_15350((double)(s * vec3d2.field_1352), (double)(-t), (double)t), 0.0, class_3532.method_15350((double)(s * vec3d2.field_1350), (double)(-t), (double)t)));
        x = cart.method_23317();
        y = cart.method_23318();
        z = cart.method_23321();
        if (Vector3i.method_10264() != 0 && class_3532.method_15357((double)x) - cartPos.method_10263() == Vector3i.method_10263() && class_3532.method_15357((double)z) - cartPos.method_10260() == Vector3i.method_10260()) {
            cart.method_5814(x, y + (double)Vector3i.method_10264(), z);
        } else if (Vector3i1.method_10264() != 0 && class_3532.method_15357((double)x) - cartPos.method_10263() == Vector3i1.method_10263() && class_3532.method_15357((double)z) - cartPos.method_10260() == Vector3i1.method_10260()) {
            cart.method_5814(x, y + (double)Vector3i1.method_10264(), z);
        }
        x = cart.method_23317();
        y = cart.method_23318();
        z = cart.method_23321();
        class_243 Vector3d3 = controller.method_61620(x, y, z);
        if (Vector3d3 != null && actualVec != null) {
            double d17 = (actualVec.field_1351 - Vector3d3.field_1351) * 0.05;
            class_243 Vector3d4 = cart.method_18798();
            double d18 = Math.sqrt(Vector3d4.method_37268());
            if (d18 > 0.0) {
                cart.method_18799(Vector3d4.method_18805((d18 + d17) / d18, 1.0, (d18 + d17) / d18));
            }
            cart.method_5814(x, Vector3d3.field_1351, z);
        }
        x = cart.method_23317();
        y = cart.method_23318();
        z = cart.method_23321();
        int j = class_3532.method_15357((double)x);
        int i = class_3532.method_15357((double)z);
        if (j != cartPos.method_10263() || i != cartPos.method_10260()) {
            class_243 Vector3d5 = cart.method_18798();
            double d26 = Math.sqrt(Vector3d5.method_37268());
            cart.method_18800(d26 * (double)(j - cartPos.method_10263()), Vector3d5.field_1351, d26 * (double)(i - cartPos.method_10260()));
        }
        cart.method_18799(previousMotion);
    }

    public static class_243 getRailVec(class_2768 shape) {
        return switch (shape) {
            case class_2768.field_12670, class_2768.field_12668, class_2768.field_12665 -> new class_243(0.0, 0.0, 1.0);
            case class_2768.field_12667, class_2768.field_12666, class_2768.field_12674 -> new class_243(1.0, 0.0, 0.0);
            case class_2768.field_12663, class_2768.field_12671 -> new class_243(1.0, 0.0, 1.0).method_1029();
            case class_2768.field_12672, class_2768.field_12664 -> new class_243(1.0, 0.0, -1.0).method_1029();
            default -> new class_243(0.0, 1.0, 0.0);
        };
    }
}

