/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.nixieTube;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.utility.DynamicComponent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

public class NixieTubeBlockEntity
extends SmartBlockEntity {
    private int redstoneStrength = 0;
    private Optional<class_2561> customText = Optional.empty();
    private int nixieIndex;
    private Couple<String> displayedStrings;
    private boolean keepAlive;
    private WeakReference<SignalBlockEntity> cachedSignalTE = new WeakReference<Object>(null);
    public SignalBlockEntity.SignalState signalState;

    public NixieTubeBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.NIXIE_TUBE, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.method_8608()) {
            return;
        }
        this.signalState = null;
        SignalBlockEntity signalBlockEntity = (SignalBlockEntity)this.cachedSignalTE.get();
        if (signalBlockEntity == null || signalBlockEntity.method_11015()) {
            class_2350 facing = NixieTubeBlock.getFacing(this.method_11010());
            class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10093(facing.method_10153()));
            if (blockEntity instanceof SignalBlockEntity) {
                SignalBlockEntity signal = (SignalBlockEntity)blockEntity;
                this.signalState = signal.getState();
                this.cachedSignalTE = new WeakReference<SignalBlockEntity>(signal);
            }
            return;
        }
        this.signalState = signalBlockEntity.getState();
    }

    @Override
    public void initialize() {
        if (this.field_11863.method_8608()) {
            this.updateDisplayedStrings();
        }
    }

    public boolean reactsToRedstone() {
        return this.customText.isEmpty();
    }

    @Nullable
    public Couple<String> getDisplayedStrings() {
        return this.displayedStrings;
    }

    public class_5250 getFullText() {
        return this.customText.map(class_2561::method_27661).orElse(class_2561.method_43470((String)("" + this.redstoneStrength)));
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.clearCustomText();
        this.redstoneStrength = signalStrength;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
        this.notifyUpdate();
    }

    public void displayCustomText(class_2561 text, int nixiePositionInRow) {
        if (text == null) {
            return;
        }
        if (this.customText.filter(d -> d.equals((Object)text)).isPresent()) {
            return;
        }
        this.customText = Optional.ofNullable(DynamicComponent.parseCustomText(this.field_11863, this.field_11867, text));
        this.nixieIndex = nixiePositionInRow;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
        this.notifyUpdate();
    }

    public void displayEmptyText(int nixiePositionInRow) {
        this.displayCustomText(class_5244.field_39003, nixiePositionInRow);
    }

    public void updateDisplayedStrings() {
        if (this.signalState != null) {
            return;
        }
        this.customText.map(class_2561::getString).ifPresentOrElse(fullText -> {
            this.displayedStrings = Couple.create(this.charOrEmpty((String)fullText, this.nixieIndex * 2), this.charOrEmpty((String)fullText, this.nixieIndex * 2 + 1));
        }, () -> {
            this.displayedStrings = Couple.create(this.redstoneStrength < 10 ? "0" : "1", String.valueOf(this.redstoneStrength % 10));
        });
    }

    public void clearCustomText() {
        this.nixieIndex = 0;
        this.customText = Optional.empty();
    }

    public int getRedstoneStrength() {
        return this.redstoneStrength;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        view.method_71426("CustomText", class_8824.field_46597).ifPresentOrElse(text -> {
            this.customText = Optional.of(text);
            this.nixieIndex = view.method_71424("CustomTextIndex", 0);
        }, () -> {
            this.redstoneStrength = view.method_71424("RedstoneStrength", 0);
        });
        if (clientPacket || this.isVirtual()) {
            this.updateDisplayedStrings();
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.customText.ifPresentOrElse(text -> {
            view.method_71465("CustomTextIndex", this.nixieIndex);
            view.method_71468("CustomText", class_8824.field_46597, text);
        }, () -> view.method_71465("RedstoneStrength", this.redstoneStrength));
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_2680 state = this.field_11863.method_8320(pos);
        if (this.method_11017().method_20526(state)) {
            this.keepAlive = true;
            this.method_31664(state);
        } else {
            super.method_66473(pos, oldState);
        }
    }

    @Override
    public void method_11012() {
        if (this.keepAlive) {
            this.keepAlive = false;
            this.field_11863.method_22350(this.field_11867).method_12007((class_2586)this);
        } else {
            super.method_11012();
        }
    }
}

