package com.zurrtum.create.catnip.nbt;

import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.nbt.*;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class NBTHelper {

    public static void putMarker(class_2487 nbt, String marker) {
        nbt.method_10556(marker, true);
    }

    // Backwards compatible with 1.20
    public static class_2338 readBlockPos(class_2487 nbt, String key) {
        class_2338 pos = nbt.method_67491(key, class_2338.field_25064).orElse(null);
        if (pos != null)
            return pos;
        class_2487 oldTag = nbt.method_68568(key);
        return new class_2338(oldTag.method_68083("X", 0), oldTag.method_68083("Y", 0), oldTag.method_68083("Z", 0));
    }

    public static <T extends Enum<?>> T readEnum(class_2487 nbt, String key, Class<T> enumClass) {
        T[] enumConstants = enumClass.getEnumConstants();
        if (enumConstants == null)
            throw new IllegalArgumentException("Non-Enum class passed to readEnum: " + enumClass.getName());
        if (nbt.method_10545(key)) {
            String name = nbt.method_68564(key, "");
            for (T t : enumConstants) {
                if (t.name().equals(name))
                    return t;
            }
        }
        return enumConstants[0];
    }

    public static <T extends Enum<?>> void writeEnum(class_2487 nbt, String key, T enumConstant) {
        nbt.method_10582(key, enumConstant.name());
    }

    public static <T> class_2499 writeCompoundList(Iterable<T> list, Function<T, class_2487> serializer) {
        class_2499 listNBT = new class_2499();
        list.forEach(t -> {
            class_2487 apply = serializer.apply(t);
            if (apply == null)
                return;
            listNBT.add(apply);
        });
        return listNBT;
    }

    public static <T> List<T> readCompoundList(class_2499 listNBT, Function<class_2487, T> deserializer) {
        List<T> list = new ArrayList<>(listNBT.size());
        listNBT.forEach(inbt -> list.add(deserializer.apply((class_2487) inbt)));
        return list;
    }

    public static void iterateCompoundList(class_2499 listNBT, Consumer<class_2487> consumer) {
        listNBT.forEach(inbt -> consumer.accept((class_2487) inbt));
    }

    public static class_2499 writeAABB(class_238 bb) {
        class_2499 bbtag = new class_2499();
        bbtag.add(class_2494.method_23244((float) bb.field_1323));
        bbtag.add(class_2494.method_23244((float) bb.field_1322));
        bbtag.add(class_2494.method_23244((float) bb.field_1321));
        bbtag.add(class_2494.method_23244((float) bb.field_1320));
        bbtag.add(class_2494.method_23244((float) bb.field_1325));
        bbtag.add(class_2494.method_23244((float) bb.field_1324));
        return bbtag;
    }

    @Nullable
    public static class_238 readAABB(class_2499 bbTag) {
        if (bbTag.isEmpty())
            return null;
        return new class_238(
            bbTag.method_68575(0, 0),
            bbTag.method_68575(1, 0),
            bbTag.method_68575(2, 0),
            bbTag.method_68575(3, 0),
            bbTag.method_68575(4, 0),
            bbTag.method_68575(5, 0)
        );
    }

    public static class_2499 writeVec3i(class_2382 vec) {
        class_2499 tag = new class_2499();
        tag.add(class_2497.method_23247(vec.method_10263()));
        tag.add(class_2497.method_23247(vec.method_10264()));
        tag.add(class_2497.method_23247(vec.method_10260()));
        return tag;
    }

    public static class_2382 readVec3i(class_2499 tag) {
        return new class_2382(tag.method_68576(0, 0), tag.method_68576(1, 0), tag.method_68576(2, 0));
    }

    public static class_2520 getINBT(class_2487 nbt, String id) {
        class_2520 inbt = nbt.method_10580(id);
        if (inbt != null)
            return inbt;
        return new class_2487();
    }

    public static class_2487 intToCompound(int i) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10569("V", i);
        return compoundTag;
    }

    public static int intFromCompound(class_2487 compoundTag) {
        return compoundTag.method_68083("V", 0);
    }

    public static void writeResourceLocation(class_2487 nbt, String key, class_2960 location) {
        nbt.method_10582(key, location.toString());
    }

    public static class_2960 readResourceLocation(class_2487 nbt, String key) {
        return class_2960.method_60654(nbt.method_68564(key, ""));
    }

}