package com.zurrtum.create.client.catnip.gui;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.LogicOp;
import com.mojang.blaze3d.platform.PolygonMode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10149;
import net.minecraft.class_2960;

public class IndexRenderPipeline extends RenderPipeline {
    private final RenderSystem.class_5590 sequentialBuffer;
    private final VertexFormat.class_5595 indexType;

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public IndexRenderPipeline(
        RenderSystem.class_5590 sequentialBuffer,
        VertexFormat.class_5595 indexType,
        class_2960 location,
        class_2960 vertexShader,
        class_2960 fragmentShader,
        class_10149 shaderDefines,
        List<String> samplers,
        List<UniformDescription> uniforms,
        Optional<BlendFunction> blendFunction,
        DepthTestFunction depthTestFunction,
        PolygonMode polygonMode,
        boolean cull,
        boolean writeColor,
        boolean writeAlpha,
        boolean writeDepth,
        LogicOp colorLogic,
        VertexFormat vertexFormat,
        VertexFormat.class_5596 vertexFormatMode,
        float depthBiasScaleFactor,
        float depthBiasConstant,
        int sortKey
    ) {
        super(
            location,
            vertexShader,
            fragmentShader,
            shaderDefines,
            samplers,
            uniforms,
            blendFunction,
            depthTestFunction,
            polygonMode,
            cull,
            writeColor,
            writeAlpha,
            writeDepth,
            colorLogic,
            vertexFormat,
            vertexFormatMode,
            depthBiasScaleFactor,
            depthBiasConstant,
            sortKey
        );
        this.sequentialBuffer = sequentialBuffer;
        this.indexType = indexType;
    }

    public GpuBuffer getIndexBuffer(int requiredSize) {
        return sequentialBuffer.method_68274(requiredSize);
    }

    public VertexFormat.class_5595 getIndexType() {
        return indexType;
    }

    public static IndexBuilder builder(Snippet... snippets) {
        IndexBuilder builder = new IndexBuilder();

        for (Snippet snippet : snippets) {
            builder.withSnippet(snippet);
        }

        return builder;
    }

    public static class IndexBuilder extends Builder {
        @Override
        public RenderPipeline build() {
            RenderPipeline pipeline = super.build();
            VertexFormat.class_5596 vertexFormatMode = pipeline.getVertexFormatMode();
            RenderSystem.class_5590 sequentialBuffer = RenderSystem.getSequentialBuffer(vertexFormatMode);
            return new IndexRenderPipeline(
                sequentialBuffer,
                sequentialBuffer.method_31924(),
                pipeline.getLocation(),
                pipeline.getVertexShader(),
                pipeline.getFragmentShader(),
                pipeline.getShaderDefines(),
                pipeline.getSamplers(),
                pipeline.getUniforms(),
                pipeline.getBlendFunction(),
                pipeline.getDepthTestFunction(),
                pipeline.getPolygonMode(),
                pipeline.isCull(),
                pipeline.isWriteColor(),
                pipeline.isWriteAlpha(),
                pipeline.isWriteDepth(),
                pipeline.getColorLogic(),
                pipeline.getVertexFormat(),
                vertexFormatMode,
                pipeline.getDepthBiasScaleFactor(),
                pipeline.getDepthBiasConstant(),
                pipeline.getSortKey()
            );
        }
    }
}
