package com.zurrtum.create.client.content.contraptions.actors.seat;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity.ContraptionRotationState;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class ContraptionPlayerPassengerRotation {

    static boolean active;
    static int prevId;
    static float prevYaw;
    static float prevPitch;

    public static void tick() {
        active = AllConfigs.client().rotateWhenSeated.get();
    }

    public static void frame(class_310 client) {
        class_1657 player = client.field_1724;
        if (!active)
            return;
        if (player == null || !player.method_5765()) {
            prevId = 0;
            return;
        }

        class_1297 vehicle = player.method_5854();
        if (!(vehicle instanceof AbstractContraptionEntity contraptionEntity))
            return;

        ContraptionRotationState rotationState = contraptionEntity.getRotationState();

        float yaw = AngleHelper.wrapAngle180((contraptionEntity instanceof CarriageContraptionEntity cce) ? cce.getViewYRot(AnimationTickHolder.getPartialTicks()) : rotationState.yRotation);

        float pitch = (contraptionEntity instanceof CarriageContraptionEntity cce) ? cce.getViewXRot(AnimationTickHolder.getPartialTicks()) : 0;

        if (prevId != contraptionEntity.method_5628()) {
            prevId = contraptionEntity.method_5628();
            prevYaw = yaw;
            prevPitch = pitch;
        }

        float yawDiff = AngleHelper.getShortestAngleDiff(yaw, prevYaw);
        float pitchDiff = AngleHelper.getShortestAngleDiff(pitch, prevPitch);

        prevYaw = yaw;
        prevPitch = pitch;

        float playerYaw = player.method_36454();
        float yawRelativeToTrain = class_3532.method_15379(AngleHelper.getShortestAngleDiff(playerYaw, -yaw - 90));
        if (yawRelativeToTrain > 120)
            pitchDiff *= -1;
        else if (yawRelativeToTrain > 60)
            pitchDiff *= 0;

        player.method_36456(playerYaw + yawDiff);
        player.method_36457(player.method_36455() + pitchDiff);
    }

}
