package com.zurrtum.create.client.content.contraptions.actors.trainControls;

import com.zurrtum.create.client.foundation.utility.ControlsUtil;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.infrastructure.packet.c2s.ControlsInputPacket;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;

public class ControlsHandler {

    public static Collection<Integer> currentlyPressed = new HashSet<>();

    public static int PACKET_RATE = 5;
    private static int packetCooldown;

    private static WeakReference<AbstractContraptionEntity> entityRef = new WeakReference<>(null);
    private static class_2338 controlsPos;

    public static void levelUnloaded() {
        packetCooldown = 0;
        entityRef = new WeakReference<>(null);
        controlsPos = null;
        currentlyPressed.clear();
    }

    public static void startControlling(class_746 player, AbstractContraptionEntity entity, class_2338 controllerLocalPos) {
        entityRef = new WeakReference<>(entity);
        controlsPos = controllerLocalPos;

        player.method_7353(CreateLang.translateDirect("contraption.controls.start_controlling", entity.getContraptionName()), true);
    }

    public static void stopControlling(class_746 player) {
        ControlsUtil.getControls().forEach(kb -> kb.method_23481(ControlsUtil.isActuallyPressed(kb)));
        AbstractContraptionEntity abstractContraptionEntity = entityRef.get();

        if (!currentlyPressed.isEmpty() && abstractContraptionEntity != null)
            player.field_3944.method_52787(new ControlsInputPacket(currentlyPressed, false, abstractContraptionEntity.method_5628(), controlsPos, false));

        packetCooldown = 0;
        entityRef = new WeakReference<>(null);
        controlsPos = null;
        currentlyPressed.clear();

        player.method_7353(CreateLang.translateDirect("contraption.controls.stop_controlling"), true);
    }

    public static void tick(class_310 mc) {
        AbstractContraptionEntity entity = entityRef.get();
        if (entity == null)
            return;
        if (packetCooldown > 0)
            packetCooldown--;

        if (entity.method_31481() || class_3675.method_15987(mc.method_22683(), GLFW.GLFW_KEY_ESCAPE)) {
            class_2338 pos = controlsPos;
            stopControlling(mc.field_1724);
            mc.field_1724.field_3944.method_52787(new ControlsInputPacket(currentlyPressed, false, entity.method_5628(), pos, true));
            return;
        }

        List<class_304> controls = ControlsUtil.getControls();
        Collection<Integer> pressedKeys = new HashSet<>();
        for (int i = 0; i < controls.size(); i++) {
            if (ControlsUtil.isActuallyPressed(controls.get(i)))
                pressedKeys.add(i);
        }

        Collection<Integer> newKeys = new HashSet<>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);

        // Released Keys
        if (!releasedKeys.isEmpty()) {
            mc.field_1724.field_3944.method_52787(new ControlsInputPacket(releasedKeys, false, entity.method_5628(), controlsPos, false));
            //			AllSoundEvents.CONTROLLER_CLICK.playAt(player.level, player.blockPosition(), 1f, .5f, true);
        }

        // Newly Pressed Keys
        if (!newKeys.isEmpty()) {
            mc.field_1724.field_3944.method_52787(new ControlsInputPacket(newKeys, true, entity.method_5628(), controlsPos, false));
            packetCooldown = PACKET_RATE;
            //			AllSoundEvents.CONTROLLER_CLICK.playAt(player.level, player.blockPosition(), 1f, .75f, true);
        }

        // Keepalive Pressed Keys
        if (packetCooldown == 0) {
            //			if (!pressedKeys.isEmpty()) {
            mc.field_1724.field_3944.method_52787(new ControlsInputPacket(pressedKeys, true, entity.method_5628(), controlsPos, false));
            packetCooldown = PACKET_RATE;
            //			}
        }

        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.method_23481(false));
    }

    @Nullable
    public static AbstractContraptionEntity getContraption() {
        return entityRef.get();
    }

    @Nullable
    public static class_2338 getControlsPos() {
        return controlsPos;
    }

}
