package com.zurrtum.create.client.content.contraptions.gantry;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlockEntity;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;

public class GantryCarriageVisual extends ShaftVisual<GantryCarriageBlockEntity> implements SimpleDynamicVisual {

    private final TransformedInstance gantryCogs;

    final class_2350 facing;
    final Boolean alongFirst;
    final class_2350.class_2351 rotationAxis;
    final float rotationMult;
    final class_2338 visualPos;

    private float lastAngle = Float.NaN;

    public GantryCarriageVisual(VisualizationContext context, GantryCarriageBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);

        gantryCogs = instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.GANTRY_COGS)).createInstance();

        facing = blockState.method_11654(GantryCarriageBlock.FACING);
        alongFirst = blockState.method_11654(GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        rotationAxis = KineticBlockEntityRenderer.getRotationAxisOf(blockEntity);

        rotationMult = getRotationMultiplier(getGantryAxis(), facing);

        visualPos = facing.method_10171() == class_2350.class_2352.field_11056 ? blockEntity.method_11016() : blockEntity.method_11016()
            .method_10093(facing.method_10153());

        animateCogs(getCogAngle());
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        float cogAngle = getCogAngle();

        if (class_3532.method_15347(cogAngle, lastAngle))
            return;

        animateCogs(cogAngle);
    }

    private float getCogAngle() {
        return GantryCarriageRenderer.getAngleForBE(blockEntity, visualPos, rotationAxis) * rotationMult;
    }

    private void animateCogs(float cogAngle) {
        gantryCogs.setIdentityTransform().translate(getVisualPosition()).center().rotateYDegrees(AngleHelper.horizontalAngle(facing))
            .rotateXDegrees(facing == class_2350.field_11036 ? 0 : facing == class_2350.field_11033 ? 180 : 90)
            .rotateYDegrees(alongFirst ^ facing.method_10166() == class_2350.class_2351.field_11048 ? 0 : 90).translate(0, -9 / 16f, 0).rotateXDegrees(-cogAngle)
            .translate(0, 9 / 16f, 0).uncenter().setChanged();
    }

    static float getRotationMultiplier(class_2350.class_2351 gantryAxis, class_2350 facing) {
        float multiplier = 1;
        if (gantryAxis == class_2350.class_2351.field_11048)
            if (facing == class_2350.field_11036)
                multiplier *= -1;
        if (gantryAxis == class_2350.class_2351.field_11052)
            if (facing == class_2350.field_11043 || facing == class_2350.field_11034)
                multiplier *= -1;

        return multiplier;
    }

    private class_2350.class_2351 getGantryAxis() {
        class_2350.class_2351 gantryAxis = class_2350.class_2351.field_11048;
        for (class_2350.class_2351 axis : Iterate.axes)
            if (axis != rotationAxis && axis != facing.method_10166())
                gantryAxis = axis;
        return gantryAxis;
    }

    @Override
    public void updateLight(float partialTick) {
        relight(gantryCogs, rotatingModel);
    }

    @Override
    protected void _delete() {
        super._delete();
        gantryCogs.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(gantryCogs);
    }
}
