package com.zurrtum.create.client.content.contraptions.glue;

import com.google.common.base.Objects;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.contraptions.glue.SuperGlueItem;
import com.zurrtum.create.content.contraptions.glue.SuperGlueSelectionHelper;
import com.zurrtum.create.infrastructure.packet.c2s.SuperGlueRemovalPacket;
import com.zurrtum.create.infrastructure.packet.c2s.SuperGlueSelectionPacket;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_239.class_240;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.util.math.*;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SuperGlueSelectionHandler {

    private static final int PASSIVE = 0x4D9162;
    private static final int HIGHLIGHT = 0x68c586;
    private static final int FAIL = 0xc5b548;

    private Object clusterOutlineSlot = new Object();
    private Object bbOutlineSlot = new Object();
    private int clusterCooldown;

    private class_2338 firstPos;
    private class_2338 hoveredPos;
    private Set<class_2338> currentCluster;
    private int glueRequired;

    private SuperGlueEntity selected;
    private class_2338 soundSourceForRemoval;

    public void tick(class_310 mc) {
        class_746 player = mc.field_1724;
        class_2338 hovered = null;
        class_1799 stack = player.method_6047();

        if (!isGlue(stack)) {
            if (firstPos != null)
                discard(player);
            return;
        }

        if (clusterCooldown > 0) {
            if (clusterCooldown == 25)
                player.method_7353(class_5244.field_39003, true);
            Outliner.getInstance().keep(clusterOutlineSlot);
            clusterCooldown--;
        }

        class_238 scanArea = player.method_5829().method_1009(32, 16, 32);

        List<SuperGlueEntity> glueNearby = mc.field_1687.method_18467(SuperGlueEntity.class, scanArea);

        selected = null;
        if (firstPos == null) {
            double range = player.method_45325(class_5134.field_47758) + 1;
            class_243 traceOrigin = player.method_33571();
            class_243 traceTarget = RaycastHelper.getTraceTarget(player, range, traceOrigin);

            double bestDistance = Double.MAX_VALUE;
            for (SuperGlueEntity glueEntity : glueNearby) {
                Optional<class_243> clip = glueEntity.method_5829().method_992(traceOrigin, traceTarget);
                if (clip.isEmpty())
                    continue;
                class_243 vec3 = clip.get();
                double distanceToSqr = vec3.method_1025(traceOrigin);
                if (distanceToSqr > bestDistance)
                    continue;
                selected = glueEntity;
                soundSourceForRemoval = class_2338.method_49638(vec3);
                bestDistance = distanceToSqr;
            }

            for (SuperGlueEntity glueEntity : glueNearby) {
                boolean h = clusterCooldown == 0 && glueEntity == selected;
                AllSpecialTextures faceTex = h ? AllSpecialTextures.GLUE : null;
                Outliner.getInstance().showAABB(glueEntity, glueEntity.method_5829()).colored(h ? HIGHLIGHT : PASSIVE)
                    .withFaceTextures(faceTex, faceTex).disableLineNormals().lineWidth(h ? 1 / 16f : 1 / 64f);
            }
        }

        class_239 hitResult = mc.field_1765;
        if (hitResult != null && hitResult.method_17783() == class_240.field_1332)
            hovered = ((class_3965) hitResult).method_17777();

        if (hovered == null) {
            hoveredPos = null;
            return;
        }

        if (firstPos != null && !firstPos.method_19771(hovered, 24)) {
            CreateLang.translate("super_glue.too_far").color(FAIL).sendStatus(player);
            return;
        }

        boolean cancel = player.method_5715();
        if (cancel && firstPos == null)
            return;

        class_238 currentSelectionBox = getCurrentSelectionBox();

        boolean unchanged = Objects.equal(hovered, hoveredPos);

        if (unchanged) {
            if (currentCluster != null) {
                boolean canReach = currentCluster.contains(hovered);
                boolean canAfford = SuperGlueSelectionHelper.collectGlueFromInventory(player, glueRequired, true);
                int color = HIGHLIGHT;
                String key = "super_glue.click_to_confirm";

                if (!canReach) {
                    color = FAIL;
                    key = "super_glue.cannot_reach";
                } else if (!canAfford) {
                    color = FAIL;
                    key = "super_glue.not_enough";
                } else if (cancel) {
                    color = FAIL;
                    key = "super_glue.click_to_discard";
                }

                CreateLang.translate(key).color(color).sendStatus(player);

                if (currentSelectionBox != null)
                    Outliner.getInstance().showAABB(bbOutlineSlot, currentSelectionBox).colored(canReach && canAfford && !cancel ? HIGHLIGHT : FAIL)
                        .withFaceTextures(AllSpecialTextures.GLUE, AllSpecialTextures.GLUE).disableLineNormals().lineWidth(1 / 16f);

                Outliner.getInstance().showCluster(clusterOutlineSlot, currentCluster).colored(0x4D9162).disableLineNormals().lineWidth(1 / 64f);
            }

            return;
        }

        hoveredPos = hovered;

        Set<class_2338> cluster = SuperGlueSelectionHelper.searchGlueGroup(mc.field_1687, firstPos, hoveredPos, true);
        currentCluster = cluster;
        glueRequired = 1;
    }

    private boolean isGlue(class_1799 stack) {
        return stack.method_7909() instanceof SuperGlueItem;
    }

    private class_238 getCurrentSelectionBox() {
        return firstPos == null || hoveredPos == null ? null : new class_238(class_243.method_24954(firstPos), class_243.method_24954(hoveredPos)).method_1012(1, 1, 1);
    }

    public boolean onMouseInput(class_310 mc, boolean attack) {
        class_746 player = mc.field_1724;
        class_638 level = mc.field_1687;

        if (!isGlue(player.method_6047()))
            return false;
        if (!player.method_7294())
            return false;

        if (attack) {
            if (selected == null)
                return false;
            player.field_3944.method_52787(new SuperGlueRemovalPacket(selected.method_5628(), soundSourceForRemoval));
            selected = null;
            clusterCooldown = 0;
            return true;
        }

        if (player.method_5715()) {
            if (firstPos != null) {
                discard(player);
                return true;
            }
            return false;
        }

        if (hoveredPos == null)
            return false;

        class_2350 face = null;
        if (mc.field_1765 instanceof class_3965 bhr) {
            face = bhr.method_17780();
            class_2680 blockState = level.method_8320(hoveredPos);
            if (blockState.method_26204() instanceof AbstractChassisBlock cb)
                if (cb.getGlueableSide(blockState, bhr.method_17780()) != null)
                    return false;
        }

        if (firstPos != null && currentCluster != null) {
            boolean canReach = currentCluster.contains(hoveredPos);
            boolean canAfford = SuperGlueSelectionHelper.collectGlueFromInventory(player, glueRequired, true);

            if (!canReach || !canAfford)
                return true;

            confirm(player);
            return true;
        }

        firstPos = hoveredPos;
        if (face != null)
            spawnParticles(level, firstPos, face, true);
        CreateLang.translate("super_glue.first_pos").sendStatus(player);
        AllSoundEvents.SLIME_ADDED.playAt(level, firstPos, 0.5F, 0.85F, false);
        level.method_8396(player, firstPos, class_3417.field_14667, class_3419.field_15245, 0.75f, 1);
        return true;
    }

    public void discard(class_746 player) {
        currentCluster = null;
        firstPos = null;
        CreateLang.translate("super_glue.abort").sendStatus(player);
        clusterCooldown = 0;
    }

    public void confirm(class_746 player) {
        player.field_3944.method_52787(new SuperGlueSelectionPacket(firstPos, hoveredPos));
        AllSoundEvents.SLIME_ADDED.playAt(player.method_73183(), hoveredPos, 0.5F, 0.95F, false);
        player.method_73183().method_8396(player, hoveredPos, class_3417.field_14667, class_3419.field_15245, 0.75f, 1);

        if (currentCluster != null)
            Outliner.getInstance().showCluster(clusterOutlineSlot, currentCluster).colored(0xB5F2C6)
                .withFaceTextures(AllSpecialTextures.GLUE, AllSpecialTextures.HIGHLIGHT_CHECKERED).disableLineNormals().lineWidth(1 / 24f);

        discard(player);
        CreateLang.translate("super_glue.success").sendStatus(player);
        clusterCooldown = 40;
    }

    public static void spawnParticles(class_1937 world, class_2338 pos, class_2350 direction, boolean fullBlock) {
        class_243 vec = class_243.method_24954(direction.method_62675());
        class_243 plane = VecHelper.axisAlingedPlaneOf(vec);
        class_243 facePos = VecHelper.getCenterOf(pos).method_1019(vec.method_1021(.5f));

        float distance = fullBlock ? 1f : .25f + .25f * (world.field_9229.method_43057() - .5f);
        plane = plane.method_1021(distance);
        class_1799 stack = new class_1799(class_1802.field_8777);

        for (int i = fullBlock ? 40 : 15; i > 0; i--) {
            class_243 offset = VecHelper.rotate(plane, 360 * world.field_9229.method_43057(), direction.method_10166());
            class_243 motion = offset.method_1029().method_1021(1 / 16f);
            if (fullBlock)
                offset = new class_243(class_3532.method_15350(offset.field_1352, -.5, .5), class_3532.method_15350(offset.field_1351, -.5, .5), class_3532.method_15350(offset.field_1350, -.5, .5));
            class_243 particlePos = facePos.method_1019(offset);
            world.method_8406(
                new class_2392(class_2398.field_11218, stack),
                particlePos.field_1352,
                particlePos.field_1351,
                particlePos.field_1350,
                motion.field_1352,
                motion.field_1351,
                motion.field_1350
            );
        }

    }
}
