package com.zurrtum.create.client.content.equipment.bell;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class SoulPulseEffectHandler {

    private final List<SoulPulseEffect> pulses;
    private final Set<class_2338> occupied;

    public SoulPulseEffectHandler() {
        pulses = new ArrayList<>();
        occupied = new HashSet<>();
    }

    public void tick(class_1937 world) {
        for (SoulPulseEffect pulse : pulses) {
            List<class_2338> spawns = pulse.tick(world);
            if (spawns == null)
                continue;

            if (pulse.canOverlap()) {
                for (class_2338 pos : spawns) {
                    pulse.spawnParticles(world, pos);
                }
            } else {
                for (class_2338 pos : spawns) {
                    if (occupied.contains(pos))
                        continue;

                    pulse.spawnParticles(world, pos);
                    pulse.added.add(pos);
                    occupied.add(pos);
                }
            }
        }

        for (SoulPulseEffect pulse : pulses) {
            if (pulse.finished() && !pulse.canOverlap())
                occupied.removeAll(pulse.added);
        }
        pulses.removeIf(SoulPulseEffect::finished);
    }

    public void addPulse(SoulPulseEffect pulse) {
        pulses.add(pulse);
    }

    public void refresh() {
        pulses.clear();
        occupied.clear();
    }

}
