package com.zurrtum.create.client.content.equipment.toolbox;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlock;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class ToolboxRenderer implements class_827<ToolboxBlockEntity, ToolboxRenderer.ToolboxRenderState> {
    public ToolboxRenderer(class_5614.class_5615 context) {
    }

    @Override
    public ToolboxRenderState method_74335() {
        return new ToolboxRenderState();
    }

    @Override
    public void updateRenderState(
        ToolboxBlockEntity be,
        ToolboxRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_1921.method_23579();
        state.lid = CachedBuffers.partial(AllPartialModels.TOOLBOX_LIDS.get(be.getColor()), state.field_62674);
        state.drawer = CachedBuffers.partial(AllPartialModels.TOOLBOX_DRAWER, state.field_62674);
        class_2350 facing = state.field_62674.method_11654(ToolboxBlock.field_11177).method_10153();
        state.yRot = class_3532.field_29847 * -facing.method_10144();
        state.xRot = class_3532.field_29847 * 135 * be.lid.getValue(tickProgress);
        float drawerOffset = be.drawers.getValue(tickProgress);
        state.offset1 = -drawerOffset * .175f;
        state.offset2 = state.offset1 * 2;
    }

    @Override
    public void render(ToolboxRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    public static class ToolboxRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer lid;
        public SuperByteBuffer drawer;
        public float yRot;
        public float xRot;
        public float offset1;
        public float offset2;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            lid.center().rotateY(yRot).uncenter().translate(0, 0.375f, 0.75f).rotateX(xRot).translate(0, -0.375f, -0.75f).light(field_62676)
                .renderInto(matricesEntry, vertexConsumer);
            drawer.center().rotateY(yRot).uncenter().translate(0, 0.125f, offset1).light(field_62676)
                .renderInto(matricesEntry, vertexConsumer);
            drawer.center().rotateY(yRot).uncenter().translate(0, 0, offset2).light(field_62676).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
