package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.foundation.utility.ServerSpeedProvider;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity.ConnectionStats;
import com.zurrtum.create.infrastructure.packet.c2s.ServerboundChainConveyorRidingPacket;
import net.minecraft.class_1109;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;

public class ChainConveyorRidingHandler {

    public static class_2338 ridingChainConveyor;
    public static float chainPosition;
    public static class_2338 ridingConnection;
    public static boolean flipped;
    public static int catchingUp;

    public static void embark(class_310 mc, class_2338 lift, float position, class_2338 connection) {
        ridingChainConveyor = lift;
        chainPosition = position;
        ridingConnection = connection;
        catchingUp = 20;
        if (mc.field_1687.method_8321(ridingChainConveyor) instanceof ChainConveyorBlockEntity clbe)
            flipped = clbe.getSpeed() < 0;

        class_2561 component = class_2561.method_43469("mount.onboard", mc.field_1690.field_1832.method_16007());
        mc.field_1705.method_1758(component, false);
        mc.method_1483().method_4873(class_1109.method_4757(class_3417.field_24062, 1f, 0.5f));
    }

    public static void clientTick(class_310 mc) {
        if (ridingChainConveyor == null)
            return;
        if (mc.method_1493())
            return;
        if (!mc.field_1724.method_24520(i -> i.method_31573(AllItemTags.CHAIN_RIDEABLE))) {
            stopRiding(mc);
            return;
        }
        class_2586 blockEntity = mc.field_1687.method_8321(ridingChainConveyor);
        if (mc.field_1724.method_5715() || !(blockEntity instanceof ChainConveyorBlockEntity clbe)) {
            stopRiding(mc);
            return;
        }
        if (ridingConnection != null && !clbe.connections.contains(ridingConnection)) {
            stopRiding(mc);
            return;
        }

        clbe.prepareStats();

        float chainYOffset = 0.5f * mc.field_1724.method_55693();
        class_243 playerPosition = mc.field_1724.method_73189().method_1031(0, mc.field_1724.method_5829().method_17940() + chainYOffset, 0);

        updateTargetPosition(mc, clbe);

        blockEntity = mc.field_1687.method_8321(ridingChainConveyor);
        if (!(blockEntity instanceof ChainConveyorBlockEntity))
            return;

        clbe = (ChainConveyorBlockEntity) blockEntity;
        clbe.prepareStats();

        class_243 targetPosition;

        if (ridingConnection != null) {
            ConnectionStats stats = clbe.connectionStats.get(ridingConnection);
            targetPosition = stats.start()
                .method_1019((stats.end().method_1020(stats.start())).method_1029().method_1021(Math.min(stats.chainLength(), chainPosition)));
        } else {
            targetPosition = class_243.method_24955(ridingChainConveyor).method_1019(VecHelper.rotate(new class_243(0, 0.25, 1), chainPosition, class_2351.field_11052));
        }

        if (catchingUp > 0)
            catchingUp--;

        class_243 diff = targetPosition.method_1020(playerPosition);
        if (catchingUp == 0 && (diff.method_1033() > 3 || diff.field_1351 < -1)) {
            stopRiding(mc);
            return;
        }

        mc.field_1724.method_18799(mc.field_1724.method_18798().method_1021(0.75).method_1019(diff.method_1021(0.25)));
        if (AnimationTickHolder.getTicks() % 10 == 0)
            mc.method_1562().method_52787(new ServerboundChainConveyorRidingPacket(ridingChainConveyor, false));
    }

    private static void stopRiding(class_310 mc) {
        if (ridingChainConveyor != null)
            mc.method_1562().method_52787(new ServerboundChainConveyorRidingPacket(ridingChainConveyor, true));
        ridingChainConveyor = null;
        ridingConnection = null;
        mc.method_1483().method_4873(class_1109.method_4757(class_3417.field_24062, 0.75f, 0.35f));
    }

    private static void updateTargetPosition(class_310 mc, ChainConveyorBlockEntity clbe) {
        float serverSpeed = ServerSpeedProvider.get();
        float speed = clbe.getSpeed() / 360f;
        float radius = 1.5f;
        float distancePerTick = Math.abs(speed);
        float degreesPerTick = (speed / (class_3532.field_29844 * radius)) * 360f;

        if (ridingConnection != null) {
            ConnectionStats stats = clbe.connectionStats.get(ridingConnection);

            if (flipped != clbe.getSpeed() < 0) {
                flipped = clbe.getSpeed() < 0;
                ridingChainConveyor = clbe.method_11016().method_10081(ridingConnection);
                chainPosition = stats.chainLength() - chainPosition;
                ridingConnection = ridingConnection.method_35830(-1);
                return;
            }

            chainPosition += serverSpeed * distancePerTick;
            chainPosition = Math.min(stats.chainLength(), chainPosition);
            if (chainPosition < stats.chainLength())
                return;

            // transfer to other
            if (mc.field_1687.method_8321(clbe.method_11016().method_10081(ridingConnection)) instanceof ChainConveyorBlockEntity clbe2) {
                chainPosition = clbe.wrapAngle(stats.tangentAngle() + 180 + 2 * 35 * (clbe.reversed ? -1 : 1));
                ridingChainConveyor = clbe2.method_11016();
                ridingConnection = null;
            }

            return;
        }

        float prevChainPosition = chainPosition;
        chainPosition += serverSpeed * degreesPerTick;
        chainPosition = clbe.wrapAngle(chainPosition);

        class_2338 nearestLooking = class_2338.field_10980;
        double bestDiff = Double.MAX_VALUE;
        for (class_2338 connection : clbe.connections) {
            double diff = class_243.method_24954(connection).method_1029().method_1025(mc.field_1724.method_5720().method_1029());
            if (diff > bestDiff)
                continue;
            nearestLooking = connection;
            bestDiff = diff;
        }

        if (nearestLooking == class_2338.field_11176)
            return;

        float offBranchAngle = clbe.connectionStats.get(nearestLooking).tangentAngle();
        if (!clbe.loopThresholdCrossed(chainPosition, prevChainPosition, offBranchAngle))
            return;

        chainPosition = 0;
        ridingConnection = nearestLooking;
    }

}
