package com.zurrtum.create.client.content.kinetics.saw;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer.FilterRenderState;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

import static net.minecraft.class_2741.field_12525;

public class SawRenderer implements class_827<SawBlockEntity, SawRenderer.SawRenderState> {
    protected final class_10442 itemModelManager;

    public SawRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    public SawRenderState method_74335() {
        return new SawRenderState();
    }

    @Override
    public void updateRenderState(
        SawBlockEntity be,
        SawRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_1921.method_23579();
        state.partialTicks = tickProgress;
        state.speed = be.getSpeed();
        updateBlade(state);
        class_1937 world = be.method_10997();
        updateItems(be.inventory, world, state);
        if (!be.method_11015()) {
            state.filter = FilteringRenderer.getFilterRenderState(
                be,
                state.field_62674,
                itemModelManager,
                be.isVirtual() ? -1 : cameraPos.method_1025(VecHelper.getCenterOf(state.field_62673))
            );
        }
        if (VisualizationManager.supportsVisualization(world)) {
            return;
        }
        class_2351 axis = ((IRotate) state.field_62674.method_26204()).getRotationAxis(state.field_62674);
        state.shaft = getRotatedModel(state.field_62674, axis);
        state.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.field_62673, axis);
        state.direction = class_2350.method_10169(axis, class_2350.class_2352.field_11056);
        state.color = KineticBlockEntityRenderer.getColor(be);
    }

    @Override
    public void render(SawRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
        if (state.items != null) {
            renderItems(state, matrices, queue);
        }
        if (state.filter != null) {
            state.filter.render(state.field_62674, queue, matrices, state.field_62676);
        }
    }

    public void updateBlade(SawRenderState state) {
        class_2680 blockState = state.field_62674;
        PartialModel partial;
        float speed = state.speed;
        boolean rotate = false;

        if (SawBlock.isHorizontal(blockState)) {
            if (speed > 0) {
                partial = AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE;
            } else if (speed < 0) {
                partial = AllPartialModels.SAW_BLADE_HORIZONTAL_REVERSED;
            } else {
                partial = AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE;
            }
        } else {
            if (speed > 0) {
                partial = AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE;
            } else if (speed < 0) {
                partial = AllPartialModels.SAW_BLADE_VERTICAL_REVERSED;
            } else {
                partial = AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE;
            }

            if (blockState.method_11654(SawBlock.AXIS_ALONG_FIRST_COORDINATE))
                rotate = true;
        }

        state.blade = CachedBuffers.partialFacing(partial, blockState);
        if (rotate) {
            state.bladeAngle = AngleHelper.rad(90);
        } else {
            state.bladeAngle = -1;
        }
    }

    public void updateItems(ProcessingInventory inventory, class_1937 world, SawRenderState state) {
        if (state.field_62674.method_11654(SawBlock.FACING) != class_2350.field_11036) {
            return;
        }
        List<class_10444> items = new ArrayList<>();
        BooleanList box = new BooleanArrayList();
        class_1799 stack = inventory.method_5438(0);
        boolean hasInput = !stack.method_7960();
        if (hasInput) {
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(renderState, stack, class_811.field_4319, world, null, 0);
            items.add(renderState);
            box.add(PackageItem.isPackage(stack));
        }
        for (int i = 1, size = inventory.method_5439(); i < size; i++) {
            stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                continue;
            }
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(renderState, stack, class_811.field_4319, world, null, 0);
            items.add(renderState);
            box.add(PackageItem.isPackage(stack));
        }
        if (items.isEmpty()) {
            return;
        }
        state.items = items;
        state.box = box;
        state.outputs = hasInput ? items.size() - 1 : items.size();
        state.alongZ = !state.field_62674.method_11654(SawBlock.AXIS_ALONG_FIRST_COORDINATE);
        state.duration = inventory.recipeDuration;
        state.remainingTime = inventory.remainingTime;
        state.appliedRecipe = inventory.appliedRecipe;
    }

    public void renderItems(SawRenderState state, class_4587 ms, class_11659 queue) {
        boolean alongZ = state.alongZ;
        float duration = state.duration;
        float speed = state.speed;
        boolean moving = duration != 0;
        float offset = moving ? state.remainingTime / duration : 0;
        if (moving) {
            float processingSpeed = class_3532.method_15363(Math.abs(speed) / 32, 1, 128);
            offset = class_3532.method_15363(offset + ((-state.partialTicks + .5f) * processingSpeed) / duration, 0.125f, 1f);
            if (!state.appliedRecipe)
                offset += 1;
            offset /= 2;
        }

        if (speed == 0)
            offset = .5f;
        if (speed < 0 ^ alongZ)
            offset = 1 - offset;

        int outputs = state.outputs;

        ms.method_22903();
        if (alongZ)
            ms.method_22907(class_7833.field_40716.rotationDegrees(90));
        ms.method_22904(outputs <= 1 ? .5 : .25, 0, offset);
        ms.method_46416(alongZ ? -1 : 0, 0, 0);

        int renderedI = 0;
        List<class_10444> items = state.items;
        BooleanList boxList = state.box;
        int light = state.field_62676;
        int size = items.size();
        PoseTransformStack msr = size > 1 && outputs > 1 ? TransformStack.of(ms) : null;
        for (int i = 0; i < size; i++) {
            class_10444 renderState = items.get(i);

            ms.method_22903();
            ms.method_46416(0, renderState.method_65608() ? .925f : 13f / 16f, 0);

            if (i > 0 && outputs > 1) {
                ms.method_22904((0.5 / (outputs - 1)) * renderedI, 0, 0);
                msr.nudge(i * 133);
            }

            boolean box = boxList.getBoolean(i);
            if (box) {
                ms.method_46416(0, 4 / 16f, 0);
                ms.method_22905(1.5f, 1.5f, 1.5f);
            } else {
                ms.method_22905(.5f, .5f, .5f);
            }

            if (!box) {
                ms.method_22907(class_7833.field_40714.rotationDegrees(90));
            }

            renderState.method_65604(ms, queue, light, class_4608.field_21444, 0);
            renderedI++;

            ms.method_22909();
        }
        ms.method_22909();
    }

    protected SuperByteBuffer getRotatedModel(class_2680 state, class_2351 axis) {
        if (state.method_11654(field_12525).method_10166().method_10179())
            return CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.method_26204().method_9598(state, class_2470.field_11464));
        return CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, KineticBlockEntityRenderer.shaft(axis));
    }

    public static class SawRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public float speed;
        public float partialTicks;
        public SuperByteBuffer blade;
        public float bladeAngle;
        public List<class_10444> items;
        public BooleanList box;
        public int outputs;
        public boolean alongZ;
        public float duration;
        public float remainingTime;
        public boolean appliedRecipe;
        public FilterRenderState filter;
        public SuperByteBuffer shaft;
        public float angle;
        public class_2350 direction;
        public Color color;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (bladeAngle != -1) {
                blade.rotateCentered(bladeAngle, class_2350.field_11036);
            }
            blade.color(0xFFFFFF).light(field_62676).renderInto(matricesEntry, vertexConsumer);
            if (shaft != null) {
                shaft.light(field_62676).rotateCentered(angle, direction).color(color).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}
