package com.zurrtum.create.client.content.logistics.tableCloth;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import com.zurrtum.create.content.logistics.tableCloth.ShoppingListItem;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.zurrtum.create.infrastructure.component.ShoppingList;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_239.class_240;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;

public class TableClothOverlayRenderer {
    public static void tick(class_310 mc) {
        if (mc.field_1761.method_2920() == class_1934.field_9219)
            return;
        class_239 mouseOver = mc.field_1765;
        if (mouseOver == null)
            return;

        class_1799 heldItem = mc.field_1724.method_6047();

        class_638 world = mc.field_1687;
        if (mouseOver.method_17783() != class_240.field_1331) {
            if (!(mouseOver instanceof class_3965 bhr))
                return;
            if (!(world.method_8321(bhr.method_17777()) instanceof TableClothBlockEntity dcbe))
                return;
            if (!dcbe.isShop())
                return;
            if (heldItem.method_31574(AllItems.CLIPBOARD))
                return;
            TableClothFilteringBehaviour behaviour = (TableClothFilteringBehaviour) dcbe.getBehaviour(TableClothFilteringBehaviour.TYPE);
            if (behaviour.targetsPriceTag(mc.field_1724, bhr))
                return;

            int alreadyPurchased = 0;
            ShoppingList list = ShoppingListItem.getList(heldItem);
            if (list != null)
                alreadyPurchased = list.getPurchases(dcbe.method_11016());

            BlueprintOverlayRenderer.displayClothShop(dcbe, alreadyPurchased, list);
            return;
        }

        class_3966 entityRay = (class_3966) mouseOver;
        if (!heldItem.method_31574(AllItems.SHOPPING_LIST))
            return;

        ShoppingList list = ShoppingListItem.getList(heldItem);
        class_2338 stockTickerPosition = StockTickerInteractionHandler.getStockTickerPosition(entityRay.method_17782());

        if (list == null || stockTickerPosition == null)
            return;
        if (!(world.method_8321(stockTickerPosition) instanceof StockTickerBlockEntity tickerBE))
            return;
        if (!tickerBE.behaviour.freqId.equals(list.shopNetwork()))
            return;

        BlueprintOverlayRenderer.displayShoppingList(mc.field_1724, list.bakeEntries(world, null));
    }
}
