package com.zurrtum.create.client.content.processing.burner;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.minecraft.class_11659;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import org.joml.Matrix4f;

public class BlazeBurnerMovementRenderBehaviour implements MovementRenderBehaviour {
    public void tick(MovementContext context) {
        if (!shouldRender(context))
            return;

        class_5819 r = context.world.method_8409();
        class_243 c = context.position;
        class_243 v = c.method_1019(VecHelper.offsetRandomly(class_243.field_1353, r, .125f).method_18805(1, 0, 1));
        if (r.method_43048(3) == 0 && context.motion.method_1033() < 1 / 64f)
            context.world.method_8406(class_2398.field_11237, v.field_1352, v.field_1351, v.field_1350, 0, 0, 0);

        LerpedFloat headAngle = getHeadAngle(context);
        boolean quickTurn = shouldRenderHat(context) && !class_3532.method_20390(context.relativeMotion.method_1033(), 0);
        headAngle.chase(
            headAngle.getValue() + AngleHelper.getShortestAngleDiff(headAngle.getValue(), getTargetAngle(context)),
            .5f,
            quickTurn ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.exp(5)
        );
        headAngle.tickChaser();
    }

    private boolean shouldRender(MovementContext context) {
        return context.state.method_61767(BlazeBurnerBlock.HEAT_LEVEL, BlazeBurnerBlock.HeatLevel.NONE) != BlazeBurnerBlock.HeatLevel.NONE;
    }

    private LerpedFloat getHeadAngle(MovementContext context) {
        if (!(context.temporaryData instanceof LerpedFloat))
            context.temporaryData = LerpedFloat.angular().startWithValue(getTargetAngle(context));
        return (LerpedFloat) context.temporaryData;
    }

    private float getTargetAngle(MovementContext context) {
        if (shouldRenderHat(context) && !class_3532.method_20390(
            context.relativeMotion.method_1033(),
            0
        ) && context.contraption.entity instanceof CarriageContraptionEntity cce) {

            float angle = AngleHelper.deg(-class_3532.method_15349(context.relativeMotion.field_1352, context.relativeMotion.field_1350));
            return cce.getInitialOrientation().method_10166() == class_2350.class_2351.field_11048 ? angle + 180 : angle;
        }

        class_1297 player = class_310.method_1551().method_1560();
        if (player != null && !player.method_5767() && context.position != null) {
            class_243 applyRotation = context.contraption.entity.reverseRotation(player.method_73189().method_1020(context.position), 1);
            double dx = applyRotation.field_1352;
            double dz = applyRotation.field_1350;
            return AngleHelper.deg(-class_3532.method_15349(dz, dx)) - 90;
        }
        return 0;
    }

    private boolean shouldRenderHat(MovementContext context) {
        class_2487 data = context.data;
        if (!data.method_10545("Conductor"))
            data.method_10556("Conductor", determineIfConducting(context));
        return data.method_68566("Conductor", false) && (context.contraption.entity instanceof CarriageContraptionEntity cce) && cce.hasSchedule();
    }

    private boolean determineIfConducting(MovementContext context) {
        Contraption contraption = context.contraption;
        if (!(contraption instanceof CarriageContraption carriageContraption))
            return false;
        class_2350 assemblyDirection = carriageContraption.getAssemblyDirection();
        for (class_2350 direction : Iterate.directionsInAxis(assemblyDirection.method_10166()))
            if (carriageContraption.inControl(context.localPos, direction))
                return true;
        return false;
    }

    @Override
    public MovementRenderState getRenderState(
        class_243 camera,
        class_327 textRenderer,
        MovementContext context,
        VirtualRenderWorld renderWorld,
        Matrix4f worldMatrix4f
    ) {
        if (!shouldRender(context)) {
            return null;
        }
        class_2680 blockState = context.state;
        BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.getHeatLevelOf(blockState);
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return null;
        }
        if (!heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            heatLevel = BlazeBurnerBlock.HeatLevel.FADING;
        }
        BlazeBurnerMovementRenderState state = new BlazeBurnerMovementRenderState(context.localPos);
        class_1937 level = context.world;
        float horizontalAngle = AngleHelper.rad(getHeadAngle(context).getValue(AnimationTickHolder.getPartialTicks(level)));
        boolean drawGoggles = context.blockEntityData.method_10545("Goggles");
        boolean drawHat = shouldRenderHat(context) || context.blockEntityData.method_10545("TrainHat");
        int hashCode = context.hashCode();
        state.data = BlazeBurnerRenderer.getBlazeBurnerRenderData(
            level,
            blockState,
            heatLevel,
            0,
            horizontalAngle,
            false,
            drawGoggles,
            drawHat ? AllPartialModels.TRAIN_HAT : null,
            hashCode
        );
        return state;
    }

    public static class BlazeBurnerMovementRenderState extends MovementRenderState {
        public BlazeBurnerRenderer.BlazeBurnerRenderData data;

        public BlazeBurnerMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            data.render(matrices, queue);
        }
    }
}
