package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.content.contraptions.render.OrientedContraptionEntityRenderer;
import com.zurrtum.create.client.content.trains.bogey.BogeyBlockEntityRenderer.BogeyRenderState;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

public class CarriageContraptionEntityRenderer extends OrientedContraptionEntityRenderer<CarriageContraptionEntity, CarriageContraptionEntityRenderer.CarriageContraptionState> {
    public CarriageContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public CarriageContraptionState createRenderState() {
        return new CarriageContraptionState();
    }

    @Override
    public boolean shouldRender(CarriageContraptionEntity entity, class_4604 clippingHelper, double cameraX, double cameraY, double cameraZ) {
        Carriage carriage = entity.getCarriage();
        if (carriage != null) {
            for (CarriageBogey bogey : carriage.bogeys) {
                if (bogey != null) {
                    bogey.couplingAnchors.replace(v -> null);
                }
            }
        }
        if (!entity.validForRender || entity.firstPositionUpdate) {
            return false;
        }
        return super.shouldRender(entity, clippingHelper, cameraX, cameraY, cameraZ);
    }

    @Override
    public void updateRenderState(CarriageContraptionEntity entity, CarriageContraptionState state, float tickProgress) {
        super.updateRenderState(entity, state, tickProgress);
        Carriage carriage = entity.getCarriage();
        if (carriage == null) {
            return;
        }
        class_1937 world = entity.method_73183();
        if (VisualizationManager.supportsVisualization(world)) {
            return;
        }
        Couple<CarriageBogey> bogeys = carriage.bogeys;
        CarriageBogey first = bogeys.getFirst();
        CarriageBogey second = bogeys.getSecond();
        class_243 position = entity.method_30950(tickProgress);
        float viewYRot = entity.getViewYRot(tickProgress);
        float viewXRot = entity.getViewXRot(tickProgress);
        int bogeySpacing = carriage.bogeySpacing;
        int cameraLight = -1;
        float firstYaw = first.yaw.getValue(tickProgress);
        float firstPitch = first.pitch.getValue(tickProgress);
        if (!state.contraption.isHiddenInPortal(class_2338.field_10980)) {
            class_243 pos = first.getAnchorPosition();
            int light;
            if (pos != null) {
                light = getBogeyLightCoords(world, pos);
            } else {
                light = cameraLight = getBogeyLightCoords(world, entity.method_31166(tickProgress));
            }
            state.firstBogey = CarriageBogeyRenderState.create(first, viewXRot, viewYRot, bogeySpacing, firstYaw, firstPitch, light, tickProgress);
        }
        first.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, firstYaw, firstPitch, true);
        if (second == null) {
            first.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, firstYaw, firstPitch, false);
        } else {
            class_2338 bogeyPos = class_2338.field_10980.method_10079(entity.getInitialOrientation().method_10160(), bogeySpacing);
            float secondYaw = second.yaw.getValue(tickProgress);
            float secondPitch = second.pitch.getValue(tickProgress);
            if (!state.contraption.isHiddenInPortal(bogeyPos)) {
                class_243 pos = second.getAnchorPosition();
                int light;
                if (pos != null) {
                    light = getBogeyLightCoords(world, pos);
                } else if (cameraLight == -1) {
                    light = getBogeyLightCoords(world, entity.method_31166(tickProgress));
                } else {
                    light = cameraLight;
                }
                state.secondBogey = CarriageBogeyRenderState.create(
                    second,
                    viewXRot,
                    viewYRot,
                    bogeySpacing,
                    secondYaw,
                    secondPitch,
                    light,
                    tickProgress
                );
            }
            second.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, secondYaw, secondPitch, false);
        }
    }

    @Override
    protected ClientContraption createClientContraption(Contraption contraption) {
        return new CarriageClientContraption((CarriageContraption) contraption);
    }

    @Override
    public void render(CarriageContraptionState state, class_4587 ms, class_11659 queue, class_12075 cameraRenderState) {
        super.render(state, ms, queue, cameraRenderState);
        if (state.firstBogey != null) {
            state.firstBogey.render(ms, queue);
        }
        if (state.secondBogey != null) {
            state.secondBogey.render(ms, queue);
        }
    }

    public static void translateBogey(class_4587 ms, CarriageBogey bogey, int bogeySpacing, float viewYRot, float viewXRot, float yaw, float pitch) {
        boolean selfUpsideDown = bogey.isUpsideDown();
        boolean leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown();
        TransformStack.of(ms).rotateYDegrees(viewYRot + 90).rotateXDegrees(-viewXRot).rotateYDegrees(180)
            .translate(0, 0, bogey.isLeading ? 0 : -bogeySpacing).rotateYDegrees(-180).rotateXDegrees(viewXRot).rotateYDegrees(-viewYRot - 90)
            .rotateYDegrees(yaw).rotateXDegrees(pitch).translate(0, .5f, 0).rotateZDegrees(selfUpsideDown ? 180 : 0)
            .translateY(selfUpsideDown != leadingUpsideDown ? 2 : 0);
    }

    public static int getBogeyLightCoords(class_1937 world, class_243 pos) {
        class_2338 lightPos = class_2338.method_49638(pos);
        return class_765.method_23687(world.method_8314(class_1944.field_9282, lightPos), world.method_8314(class_1944.field_9284, lightPos));
    }

    public static class CarriageContraptionState extends OrientedContraptionState {
        public CarriageBogeyRenderState firstBogey;
        public CarriageBogeyRenderState secondBogey;
    }

    public static class CarriageBogeyRenderState {
        public BogeyRenderState data;
        public float viewYRot;
        public float viewXRot;
        public float yRot;
        public int offsetZ;
        public float yaw;
        public float pitch;
        public float zRot;
        public int offsetY;

        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            if (offsetZ != 0) {
                matrices.method_22907(class_7833.field_40716.rotation(viewYRot));
                matrices.method_22907(class_7833.field_40714.rotation(-viewXRot));
                matrices.method_22907(class_7833.field_40716.rotation(yRot));
                matrices.method_46416(0, 0, offsetZ);
                matrices.method_22907(class_7833.field_40716.rotation(-yRot));
                matrices.method_22907(class_7833.field_40714.rotation(viewXRot));
                matrices.method_22907(class_7833.field_40716.rotation(-viewYRot));
            }
            matrices.method_22907(class_7833.field_40716.rotation(yaw));
            matrices.method_22907(class_7833.field_40714.rotation(pitch));
            matrices.method_46416(0, 0.5f, 0);
            if (zRot != 0) {
                matrices.method_22907(class_7833.field_40718.rotation(zRot));
            }
            matrices.method_46416(0, offsetY, 0);
            data.render(matrices, queue);
            matrices.method_22909();
        }

        @Nullable
        public static CarriageBogeyRenderState create(
            CarriageBogey bogey,
            float viewXRot,
            float viewYRot,
            int bogeySpacing,
            float yaw,
            float pitch,
            int light,
            float tickProgress
        ) {
            float wheelAngle = bogey.wheelAngle.getValue(tickProgress);
            BogeyRenderState data = AllBogeyStyleRenders.getRenderData(
                bogey.getStyle(),
                bogey.getSize(),
                tickProgress,
                light,
                wheelAngle,
                bogey.bogeyData,
                true
            );
            if (data == null) {
                return null;
            }
            CarriageBogeyRenderState state = new CarriageBogeyRenderState();
            state.data = data;
            if (!bogey.isLeading) {
                state.viewYRot = class_3532.field_29847 * (viewYRot + 90);
                state.viewXRot = class_3532.field_29847 * viewXRot;
                state.yRot = class_3532.field_29847 * 180;
                state.offsetZ = -bogeySpacing;
            }
            state.yaw = class_3532.field_29847 * yaw;
            state.pitch = class_3532.field_29847 * pitch;
            boolean selfUpsideDown = bogey.isUpsideDown();
            if (selfUpsideDown) {
                state.zRot = class_3532.field_29847 * 180;
            }
            boolean leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown();
            if (selfUpsideDown != leadingUpsideDown) {
                state.offsetY = 2;
            }
            return state;
        }
    }
}
