package com.zurrtum.create.client.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.trains.schedule.IScheduleInput;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.schedule.condition.TimedWaitCondition;
import com.zurrtum.create.content.trains.schedule.condition.TimedWaitCondition.TimeUnit;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class TimedWaitConditionRender<T extends TimedWaitCondition> implements IScheduleInput<T> {
    protected class_2561 formatTime(T input, boolean compact) {
        int value = input.getValue();
        TimeUnit unit = input.getUnit();
        if (compact) {
            return class_2561.method_43470(value + unit.suffix);
        }
        return class_2561.method_43470(value + " ").method_10852(CreateLang.translateDirect(getUnitKey(unit)));
    }

    @Override
    public List<class_2561> getTitleAs(T input, String type) {
        class_2960 id = input.getId();
        return ImmutableList.of(
            class_2561.method_43471(id.method_12836() + ".schedule." + type + "." + id.method_12832()),
            CreateLang.translateDirect("schedule.condition.for_x_time", formatTime(input, false)).method_27692(class_124.field_1062)
        );
    }

    @Override
    public class_1799 getSecondLineIcon() {
        return new class_1799(class_1802.field_8619);
    }

    @Override
    public List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of(CreateLang.translateDirect("generic.duration"));
    }

    public String getUnitKey(TimeUnit unit) {
        return "generic.unit." + unit.name().toLowerCase(Locale.ROOT);
    }

    public List<class_2561> getUnitOptions() {
        return CreateLang.translatedOptions(null, getUnitKey(TimeUnit.TICKS), getUnitKey(TimeUnit.SECONDS), getUnitKey(TimeUnit.MINUTES));
    }

    public void initConfigurationWidgets(T input, ModularGuiLineBuilder builder) {
        builder.addScrollInput(
            0, 31, (i, l) -> {
                i.titled(CreateLang.translateDirect("generic.duration")).withShiftStep(15).withRange(0, 121);
                i.lockedTooltipX = -15;
                i.lockedTooltipY = 35;
            }, "Value"
        );

        builder.addSelectionScrollInput(
            36, 85, (i, l) -> {
                i.forOptions(getUnitOptions()).titled(CreateLang.translateDirect("generic.timeUnit"));
            }, "TimeUnit"
        );
    }
}
