package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline.BezierPointSelection;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackTargetingBlockItem;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import com.zurrtum.create.infrastructure.packet.c2s.CurvedTrackDestroyPacket;
import com.zurrtum.create.infrastructure.packet.c2s.CurvedTrackSelectionPacket;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class CurvedTrackInteraction {
    static int breakTicks;
    static int breakTimeout;
    static float breakProgress;
    static class_2338 breakPos;

    public static void clientTick(class_310 mc) {
        BezierPointSelection result = TrackBlockOutline.result;
        class_746 player = mc.field_1724;
        class_638 level = mc.field_1687;

        if (!player.method_31549().field_7476)
            return;

        if (mc.field_1690.field_1886.method_1434() && result != null) {
            breakPos = result.blockEntity().method_11016();
            class_2680 blockState = level.method_8320(breakPos);
            if (blockState.method_26215()) {
                resetBreakProgress(level, player);
                return;
            }

            if (breakTicks % 4.0F == 0.0F) {
                class_2498 soundtype = blockState.method_26231();
                mc.method_1483().method_4873(new class_1109(
                    soundtype.method_10596(),
                    class_3419.field_15245,
                    (soundtype.method_10597() + 1.0F) / 8.0F,
                    soundtype.method_10599() * 0.5F,
                    level.field_9229,
                    class_2338.method_49638(result.vec())
                ));
            }

            boolean creative = player.method_31549().field_7477;

            breakTicks++;
            breakTimeout = 2;
            breakProgress += creative ? 0.125f : blockState.method_26165(player, level, breakPos) / 8f;

            class_243 vec = VecHelper.offsetRandomly(result.vec(), level.field_9229, 0.25f);
            level.method_8406(new class_2388(class_2398.field_11217, blockState), vec.field_1352, vec.field_1351, vec.field_1350, 0, 0, 0);

            int progress = (int) (breakProgress * 10.0F) - 1;
            level.method_8517(player.method_5628(), breakPos, progress);
            player.method_6104(class_1268.field_5808);

            if (breakProgress >= 1) {
                player.field_3944.method_52787(new CurvedTrackDestroyPacket(
                    breakPos,
                    result.loc().curveTarget(),
                    class_2338.method_49638(result.vec()),
                    false
                ));
                resetBreakProgress(level, player);
            }

            return;
        }

        if (breakTimeout == 0)
            return;
        if (--breakTimeout > 0)
            return;

        resetBreakProgress(level, player);
    }

    private static void resetBreakProgress(class_638 level, class_746 player) {
        if (breakPos != null && level != null)
            level.method_8517(player.method_5628(), breakPos, -1);

        breakProgress = 0;
        breakTicks = 0;
        breakPos = null;
    }

    public static boolean onClickInput(class_310 mc, boolean attack) {
        BezierPointSelection result = TrackBlockOutline.result;
        if (result == null)
            return false;

        class_746 player = mc.field_1724;
        if (player == null)
            return false;
        class_638 level = mc.field_1687;
        if (level == null)
            return false;

        if (attack)
            return true;

        class_1799 heldItem = player.method_6047();
        class_1792 item = heldItem.method_7909();
        if (heldItem.method_31573(AllItemTags.TRACKS)) {
            player.method_7353(CreateLang.translateDirect("track.turn_start").method_27692(class_124.field_1061), true);
            return true;
        }
        if (item instanceof TrackTargetingBlockItem) {
            useOnCurve(player, result);
            return true;
        }
        if (heldItem.method_31574(AllItems.WRENCH) && player.method_5715()) {
            player.field_3944.method_52787(new CurvedTrackDestroyPacket(
                result.blockEntity().method_11016(),
                result.loc().curveTarget(),
                class_2338.method_49638(result.vec()),
                true
            ));
            resetBreakProgress(level, player);
            return true;
        }

        return false;
    }

    public static void useOnCurve(class_746 player, BezierPointSelection selection) {
        TrackBlockEntity be = selection.blockEntity();
        BezierTrackPointLocation loc = selection.loc();
        boolean front = player.method_5720().method_1026(selection.direction()) < 0;

        player.field_3944.method_52787(new CurvedTrackSelectionPacket(
            be.method_11016(),
            loc.curveTarget(),
            front,
            loc.segment(),
            player.method_31548().method_67532()
        ));
    }

}