package com.zurrtum.create.client.flywheel.api.registry;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

import java.util.Collection;
import java.util.Set;
import net.minecraft.class_2960;

@ApiStatus.NonExtendable
public interface IdRegistry<T> extends Iterable<T> {
    void register(class_2960 var1, T var2);

    <S extends T> S registerAndGet(class_2960 var1, S var2);

    @Nullable T get(class_2960 var1);

    @Nullable class_2960 getId(T var1);

    T getOrThrow(class_2960 var1);

    class_2960 getIdOrThrow(T var1);

    @UnmodifiableView
    Set<class_2960> getAllIds();

    @UnmodifiableView
    Collection<T> getAll();

    boolean isFrozen();
}
