package com.zurrtum.create.client.flywheel.lib.transform;

import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public interface Affine<Self extends Affine<Self>> extends Translate<Self>, Rotate<Self>, Scale<Self> {
    default Self rotateAround(Quaternionfc quaternion, float x, float y, float z) {
        return translate(x, y, z).rotate(quaternion).translateBack(x, y, z);
    }

    default Self rotateAround(Quaternionfc quaternion, Vector3fc vec) {
        return rotateAround(quaternion, vec.x(), vec.y(), vec.z());
    }

    default Self rotateCentered(Quaternionfc q) {
        return rotateAround(q, CENTER, CENTER, CENTER);
    }

    default Self rotateCentered(float radians, float axisX, float axisY, float axisZ) {
        if (radians == 0) {
            return self();
        }
        return rotateCentered(new Quaternionf().setAngleAxis(radians, axisX, axisY, axisZ));
    }

    default Self rotateCentered(float radians, class_7833 axis) {
        if (radians == 0) {
            return self();
        }
        return rotateCentered(axis.rotation(radians));
    }

    default Self rotateCentered(float radians, Vector3fc axis) {
        return rotateCentered(radians, axis.x(), axis.y(), axis.z());
    }

    default Self rotateCentered(float radians, class_2350.class_2351 axis) {
        return rotateCentered(radians, class_2350.method_10169(axis, class_2350.class_2352.field_11056));
    }

    default Self rotateCentered(float radians, class_2350 axis) {
        return rotateCentered(radians, axis.method_10148(), axis.method_10164(), axis.method_10165());
    }

    default Self rotateCenteredDegrees(float degrees, float axisX, float axisY, float axisZ) {
        return rotateCentered(class_3532.field_29847 * degrees, axisX, axisY, axisZ);
    }

    default Self rotateCenteredDegrees(float degrees, class_7833 axis) {
        return rotateCentered(class_3532.field_29847 * degrees, axis);
    }

    default Self rotateCenteredDegrees(float degrees, Vector3fc axis) {
        return rotateCentered(class_3532.field_29847 * degrees, axis);
    }

    default Self rotateCenteredDegrees(float degrees, class_2350 axis) {
        return rotateCentered(class_3532.field_29847 * degrees, axis);
    }

    default Self rotateCenteredDegrees(float degrees, class_2350.class_2351 axis) {
        return rotateCentered(class_3532.field_29847 * degrees, axis);
    }

    default Self rotateXCentered(float radians) {
        return rotateCentered(radians, class_7833.field_40714);
    }

    default Self rotateYCentered(float radians) {
        return rotateCentered(radians, class_7833.field_40716);
    }

    default Self rotateZCentered(float radians) {
        return rotateCentered(radians, class_7833.field_40718);
    }

    default Self rotateXCenteredDegrees(float degrees) {
        return rotateXCentered(class_3532.field_29847 * degrees);
    }

    default Self rotateYCenteredDegrees(float degrees) {
        return rotateYCentered(class_3532.field_29847 * degrees);
    }

    default Self rotateZCenteredDegrees(float degrees) {
        return rotateZCentered(class_3532.field_29847 * degrees);
    }
}
