package com.zurrtum.create.client.foundation.gui.menu;

import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.TickableGuiEventListener;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import net.minecraft.class_1109;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_6379;
import net.minecraft.class_638;
import net.minecraft.class_768;
import net.minecraft.class_9129;
import net.minecraft.client.gui.*;
import org.lwjgl.glfw.GLFW;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSimiContainerScreen<T extends class_1703> extends class_465<T> {
    protected int windowXOffset, windowYOffset;

    public AbstractSimiContainerScreen(T container, class_1661 inv, class_2561 title) {
        super(container, inv, title);
    }

    /**
     * This method must be called before {@code super.init()}!
     */
    protected void setWindowSize(int width, int height) {
        field_2792 = width;
        field_2779 = height;
    }

    /**
     * This method must be called before {@code super.init()}!
     */
    protected void setWindowOffset(int xOffset, int yOffset) {
        windowXOffset = xOffset;
        windowYOffset = yOffset;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        field_2776 += windowXOffset;
        field_2800 += windowYOffset;
    }

    @Override
    protected void method_37432() {
        for (class_364 listener : method_25396()) {
            if (listener instanceof TickableGuiEventListener tickable) {
                tickable.tick();
            }
        }
    }

    @SuppressWarnings("unchecked")
    protected <W extends class_364 & class_4068 & class_6379> void addRenderableWidgets(W... widgets) {
        for (W widget : widgets) {
            method_37063(widget);
        }
    }

    protected <W extends class_364 & class_4068 & class_6379> void addRenderableWidgets(Collection<W> widgets) {
        for (W widget : widgets) {
            method_37063(widget);
        }
    }

    protected void removeWidgets(class_364... widgets) {
        for (class_364 widget : widgets) {
            method_37066(widget);
        }
    }

    protected void removeWidgets(Collection<? extends class_364> widgets) {
        for (class_364 widget : widgets) {
            method_37066(widget);
        }
    }

	/*@Override
	public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
		NeoForge.EVENT_BUS.post(new ContainerScreenEvent.Render.Background(this, pGuiGraphics, pMouseX, pMouseY));
		renderBg(pGuiGraphics, pPartialTick, pMouseX, pMouseY);
	}*/

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = AnimationTickHolder.getPartialTicksUI(field_22787.method_61966());

        super.method_25394(graphics, mouseX, mouseY, partialTicks);

        renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        // no-op to prevent screen- and inventory-title from being rendered at incorrect
        // location
        // could also set this.titleX/Y and this.playerInventoryTitleX/Y to the proper
        // values instead
    }

    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        method_2380(graphics, mouseX, mouseY);
        for (class_4068 widget : field_33816) {
            if (widget instanceof AbstractSimiWidget simiWidget && simiWidget.method_25405(mouseX, mouseY)) {
                List<class_2561> tooltip = simiWidget.getToolTip();
                if (tooltip.isEmpty())
                    continue;
                int ttx = simiWidget.lockedTooltipX == -1 ? mouseX : simiWidget.lockedTooltipX + simiWidget.method_46426();
                int tty = simiWidget.lockedTooltipY == -1 ? mouseY : simiWidget.lockedTooltipY + simiWidget.method_46427();
                graphics.method_51434(field_22793, tooltip, ttx, tty);
            }
        }
    }

    public int getLeftOfCentered(int textureWidth) {
        return field_2776 - windowXOffset + (field_2792 - textureWidth) / 2;
    }

    public void renderPlayerInventory(class_332 graphics, int x, int y) {
        AllGuiTextures.PLAYER_INVENTORY.render(graphics, x, y);
        graphics.method_51439(field_22793, field_29347, x + 8, y + 6, 0xFF404040, false);
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (method_25399() instanceof class_342 && input.comp_4795() != GLFW.GLFW_KEY_ESCAPE)
            return method_25399().method_25404(input);
        return super.method_25404(input);
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        if (method_25399() != null && !method_25399().method_25405(click.comp_4798(), click.comp_4799()))
            method_25395(null);
        return super.method_25402(click, doubled);
    }

    @Override
    public class_364 method_25399() {
        class_364 focused = super.method_25399();
        if (focused instanceof class_339 && !focused.method_25370())
            focused = null;
        method_25395(focused);
        return focused;
    }

    /**
     * Used for moving JEI out of the way of extra things like block renders.
     *
     * @return the space that the GUI takes up outside the normal rectangle defined
     * by {@link class_476}.
     */
    public List<class_768> getExtraAreas() {
        return Collections.emptyList();
    }

    @Deprecated
    protected void debugWindowArea(class_332 graphics) {
        graphics.method_25294(field_2776 + field_2792, field_2800 + field_2779, field_2776, field_2800, 0xD3D3D3D3);
    }

    @Deprecated
    protected void debugExtraAreas(class_332 graphics) {
        for (class_768 area : getExtraAreas()) {
            graphics.method_25294(area.method_3321() + area.method_3319(), area.method_3322() + area.method_3320(), area.method_3321(), area.method_3322(), 0xD3D3D3D3);
        }
    }

    protected void playUiSound(class_3414 sound, float volume, float pitch) {
        class_310.method_1551().method_1483().method_4873(class_1109.method_4757(sound, pitch, volume * 0.25f));
    }

    public static class_1799 getStack(class_9129 extraData) {
        return class_1799.field_48349.decode(extraData);
    }

    @SuppressWarnings("unchecked")
    public static <T extends class_2586> T getBlockEntity(class_310 mc, class_9129 extraData) {
        class_638 world = mc.field_1687;
        if (world == null) {
            return null;
        }
        return (T) world.method_8321(extraData.method_10811());
    }
}
