package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;

public record SandpaperPolishingDisplay(EntryIngredient input, EntryIngredient output, Optional<class_2960> location) implements Display {
    public static final DisplaySerializer<SandpaperPolishingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(SandpaperPolishingDisplay::input),
            EntryIngredient.codec().fieldOf("output").forGetter(SandpaperPolishingDisplay::output),
            class_2960.field_25139.optionalFieldOf("location").forGetter(SandpaperPolishingDisplay::location)
        ).apply(instance, SandpaperPolishingDisplay::new)), class_9139.method_56436(
            EntryIngredient.streamCodec(),
            SandpaperPolishingDisplay::input,
            EntryIngredient.streamCodec(),
            SandpaperPolishingDisplay::output,
            class_9135.method_56382(class_2960.field_48267),
            SandpaperPolishingDisplay::location,
            SandpaperPolishingDisplay::new
        )
    );

    public SandpaperPolishingDisplay(class_8786<SandPaperPolishingRecipe> entry) {
        this(entry.comp_1932().method_29177(), entry.comp_1933());
    }

    public SandpaperPolishingDisplay(class_2960 id, SandPaperPolishingRecipe recipe) {
        this(EntryIngredients.ofIngredient(recipe.ingredient()), EntryIngredients.of(recipe.result()), Optional.of(id));
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.SANDPAPER_POLISHING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
