package com.zurrtum.create.content.contraptions.actors.roller;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.content.contraptions.actors.AttachedActorBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.placement.PoleHelper;
import org.jetbrains.annotations.NotNull;

import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class RollerBlock extends AttachedActorBlock implements IBE<RollerBlockEntity> {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public static final MapCodec<RollerBlock> CODEC = method_54094(RollerBlock::new);

    public RollerBlock(class_2251 p_i48377_1_) {
        super(p_i48377_1_);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        return withWater(method_9564().method_11657(field_11177, context.method_8042().method_10153()), context);
    }

    @Override
    public Class<RollerBlockEntity> getBlockEntityClass() {
        return RollerBlockEntity.class;
    }

    @Override
    public class_2591<? extends RollerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.MECHANICAL_ROLLER;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return class_259.method_1077();
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        return true;
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        withBlockEntityDo(pLevel, pPos, RollerBlockEntity::searchForSharedValues);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!player.method_5715() && player.method_7294()) {
            if (placementHelper.matchesItem(stack)) {
                placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);
                return class_1269.field_5812;
            }
        }

        return class_1269.field_52423;
    }

    private static class PlacementHelper extends PoleHelper<class_2350> {

        public PlacementHelper() {
            super(state -> state.method_27852(AllBlocks.MECHANICAL_ROLLER), state -> state.method_11654(field_11177).method_10170().method_10166(), field_11177);
        }

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return stack -> stack.method_31574(AllItems.MECHANICAL_ROLLER);
        }

    }

    @Override
    protected @NotNull MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }

}
