package com.zurrtum.create.content.contraptions.data;

import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class ContraptionSyncLimiting {
    /**
     * Contraption entity sync is limited by the clientbound custom payload limit, since that's what Forge's
     * extended spawn packet uses. The NBT limit is irrelevant since it's bypassed on deserialization.
     */
    public static final int SIZE_LIMIT = 1_048_576;

    // increased packet limits provided by other mods.
    public static final int PACKET_FIXER_LIMIT = SIZE_LIMIT * 100;
    public static final int XL_PACKETS_LIMIT = Integer.MAX_VALUE;

    // leave some room for the rest of the packet.
    public static final int BUFFER = 20_000;

    // the actual limit to be used
    public static final int LIMIT = class_156.method_656(() -> {
        // the smallest limit needs to be used, as we can't guarantee that all mixins are applied if multiple are present.
        //TODO
        //        if (Mods.PACKETFIXER.isLoaded()) {
        //            return PACKET_FIXER_LIMIT;
        //        } else if (Mods.XLPACKETS.isLoaded()) {
        //            return XL_PACKETS_LIMIT;
        //        }

        // none are present, use vanilla default
        return SIZE_LIMIT;
    }) - BUFFER;

    public static void writeSafe(class_2487 compound, class_2540 dst) {
        // Write the NBT, but take note of where we were before in case we need to roll back.
        int writerIndexBefore = dst.writerIndex();
        dst.method_10794(compound);

        if (dst.writerIndex() > ContraptionSyncLimiting.LIMIT) {
            // Too large to fit in a packet, so roll back to where
            // we were before and write null so the client can detect it.
            dst.method_52990(writerIndexBefore);
            dst.method_10794(null);
        }
    }
}