package com.zurrtum.create.content.contraptions.gantry;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlockEntity;
import com.zurrtum.create.infrastructure.packet.s2c.GantryContraptionUpdatePacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class GantryContraptionEntity extends AbstractContraptionEntity {

    class_2350 movementAxis;
    public double clientOffsetDiff;
    public double axisMotion;

    public double sequencedOffsetLimit;

    public GantryContraptionEntity(class_1299<? extends GantryContraptionEntity> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        sequencedOffsetLimit = -1;
    }

    public static GantryContraptionEntity create(class_1937 world, Contraption contraption, class_2350 movementAxis) {
        GantryContraptionEntity entity = new GantryContraptionEntity(AllEntityTypes.GANTRY_CONTRAPTION, world);
        entity.setContraption(contraption);
        entity.movementAxis = movementAxis;
        return entity;
    }

    public void limitMovement(double maxOffset) {
        sequencedOffsetLimit = maxOffset;
    }

    @Override
    protected void tickContraption() {
        if (!(contraption instanceof GantryContraption))
            return;

        double prevAxisMotion = axisMotion;
        class_1937 world = method_73183();
        if (world.method_8608()) {
            clientOffsetDiff *= .75f;
            updateClientMotion();
        }

        checkPinionShaft();
        tickActors();
        class_243 movementVec = method_18798();

        if (ContraptionCollider.collideBlocks(this)) {
            if (!world.method_8608())
                disassemble();
            return;
        }

        if (!isStalled() && field_6012 > 2) {
            if (sequencedOffsetLimit >= 0)
                movementVec = VecHelper.clampComponentWise(movementVec, (float) sequencedOffsetLimit);
            move(movementVec.field_1352, movementVec.field_1351, movementVec.field_1350);
            if (sequencedOffsetLimit > 0)
                sequencedOffsetLimit = Math.max(0, sequencedOffsetLimit - movementVec.method_1033());
        }

        if (Math.signum(prevAxisMotion) != Math.signum(axisMotion) && prevAxisMotion != 0)
            contraption.stop(world);
        if (!world.method_8608() && (prevAxisMotion != axisMotion || field_6012 % 3 == 0))
            sendPacket();
    }

    @Override
    public void disassemble() {
        sequencedOffsetLimit = -1;
        super.disassemble();
    }

    protected void checkPinionShaft() {
        class_243 movementVec;
        class_2350 facing = ((GantryContraption) contraption).getFacing();
        class_243 currentPosition = getAnchorVec().method_1031(.5, .5, .5);
        class_2338 gantryShaftPos = class_2338.method_49638(currentPosition).method_10093(facing.method_10153());

        class_1937 world = method_73183();
        class_2586 be = world.method_8321(gantryShaftPos);
        if (!(be instanceof GantryShaftBlockEntity gantryShaftBlockEntity) || !be.method_11010().method_27852(AllBlocks.GANTRY_SHAFT)) {
            if (!world.method_8608()) {
                setContraptionMotion(class_243.field_1353);
                disassemble();
            }
            return;
        }

        class_2680 blockState = be.method_11010();
        class_2350 direction = blockState.method_11654(GantryShaftBlock.FACING);

        float pinionMovementSpeed = gantryShaftBlockEntity.getPinionMovementSpeed();
        if (blockState.method_11654(GantryShaftBlock.POWERED) || pinionMovementSpeed == 0) {
            setContraptionMotion(class_243.field_1353);
            if (!world.method_8608())
                disassemble();
            return;
        }

        if (sequencedOffsetLimit >= 0)
            pinionMovementSpeed = (float) class_3532.method_15350(pinionMovementSpeed, -sequencedOffsetLimit, sequencedOffsetLimit);
        movementVec = class_243.method_24954(direction.method_62675()).method_1021(pinionMovementSpeed);

        class_243 nextPosition = currentPosition.method_1019(movementVec);
        double currentCoord = direction.method_10166().method_10172(currentPosition.field_1352, currentPosition.field_1351, currentPosition.field_1350);
        double nextCoord = direction.method_10166().method_10172(nextPosition.field_1352, nextPosition.field_1351, nextPosition.field_1350);

        if ((class_3532.method_15357(currentCoord) + .5f < nextCoord != (pinionMovementSpeed * direction.method_10171().method_10181() < 0)))
            if (!gantryShaftBlockEntity.canAssembleOn()) {
                setContraptionMotion(class_243.field_1353);
                if (!world.method_8608())
                    disassemble();
                return;
            }

        if (world.method_8608())
            return;

        axisMotion = pinionMovementSpeed;
        setContraptionMotion(movementVec);
    }

    @Override
    protected void writeAdditional(class_11372 view, boolean spawnPacket) {
        view.method_71468("GantryAxis", class_2350.field_29502, movementAxis);
        if (sequencedOffsetLimit >= 0)
            view.method_71463("SequencedOffsetLimit", sequencedOffsetLimit);
        super.writeAdditional(view, spawnPacket);
    }

    @Override
    protected void readAdditional(class_11368 view, boolean spawnPacket) {
        movementAxis = view.method_71426("GantryAxis", class_2350.field_29502).orElse(class_2350.field_11033);
        sequencedOffsetLimit = view.method_71422("SequencedOffsetLimit", -1);
        super.readAdditional(view, spawnPacket);
    }

    @Override
    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        return new StructureTransform(class_2338.method_49638(getAnchorVec().method_1031(.5, .5, .5)), 0, 0, 0);
    }

    @Override
    protected float getStalledAngle() {
        return 0;
    }

    @Override
    public void method_5859(double destX, double destY, double destZ) {
    }

    @Override
    public void method_66246(class_243 pos, float yaw, float pitch) {
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
        method_23327(x, y, z);
        clientOffsetDiff = 0;
    }

    @Override
    public ContraptionRotationState getRotationState() {
        return ContraptionRotationState.NONE;
    }

    public void updateClientMotion() {
        float modifier = movementAxis.method_10171().method_10181();
        class_243 motion = class_243.method_24954(movementAxis.method_62675())
            .method_1021((axisMotion + clientOffsetDiff * modifier / 2f) * AllClientHandle.INSTANCE.getServerSpeed());
        if (sequencedOffsetLimit >= 0)
            motion = VecHelper.clampComponentWise(motion, (float) sequencedOffsetLimit);
        setContraptionMotion(motion);
    }

    public double getAxisCoord() {
        class_243 anchorVec = getAnchorVec();
        return movementAxis.method_10166().method_10172(anchorVec.field_1352, anchorVec.field_1351, anchorVec.field_1350);
    }

    public void sendPacket() {
        class_3215 chunkManager = ((class_3218) method_73183()).method_14178();
        chunkManager.method_18754(this, new GantryContraptionUpdatePacket(method_5628(), getAxisCoord(), axisMotion, sequencedOffsetLimit));
    }
}
