package com.zurrtum.create.content.contraptions.glue;

import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.catnip.data.Iterate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class SuperGlueSelectionHelper {

    public static Set<class_2338> searchGlueGroup(class_1937 level, class_2338 startPos, class_2338 endPos, boolean includeOther) {
        if (endPos == null || startPos == null)
            return null;

        class_238 bb = SuperGlueEntity.span(startPos, endPos);

        List<class_2338> frontier = new ArrayList<>();
        Set<class_2338> visited = new HashSet<>();
        Set<class_2338> attached = new HashSet<>();
        Set<SuperGlueEntity> cachedOther = new HashSet<>();

        visited.add(startPos);
        frontier.add(startPos);

        while (!frontier.isEmpty()) {
            class_2338 currentPos = frontier.removeFirst();
            attached.add(currentPos);

            for (class_2350 d : Iterate.directions) {
                class_2338 offset = currentPos.method_10093(d);
                boolean gluePresent = includeOther && SuperGlueEntity.isGlued(level, currentPos, d, cachedOther);
                boolean alreadySticky = includeOther && SuperGlueEntity.isSideSticky(level, currentPos, d) || SuperGlueEntity.isSideSticky(
                    level,
                    offset,
                    d.method_10153()
                );

                if (!alreadySticky && !gluePresent && !bb.method_1006(class_243.method_24953(offset)))
                    continue;
                if (!BlockMovementChecks.isMovementNecessary(level.method_8320(offset), level, offset))
                    continue;
                if (!SuperGlueEntity.isValidFace(level, currentPos, d) || !SuperGlueEntity.isValidFace(level, offset, d.method_10153()))
                    continue;

                if (visited.add(offset))
                    frontier.add(offset);
            }
        }

        if (attached.size() < 2 && attached.contains(endPos))
            return null;

        return attached;
    }

    public static boolean collectGlueFromInventory(class_1657 player, int requiredAmount, boolean simulate) {
        if (player.method_68878())
            return true;
        if (requiredAmount == 0)
            return true;

        class_2371<class_1799> items = player.method_31548().method_67533();
        for (int i = -1; i < class_1661.field_30638; i++) {
            int slot = i == -1 ? player.method_31548().method_67532() : i;
            class_1799 stack = items.get(slot);
            if (stack.method_7960())
                continue;
            if (!(stack.method_7909() instanceof SuperGlueItem))
                continue;

            int charges = Math.min(requiredAmount, stack.method_7936() - stack.method_7919());

            stack.method_7970(charges, player, class_1304.field_6173);

            requiredAmount -= charges;
            if (requiredAmount <= 0)
                return true;
        }

        return false;
    }

}
