package com.zurrtum.create.content.equipment.armor;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_4050;

public class DivingBootsItem extends class_1792 {
    public static final class_1304 SLOT = class_1304.field_6166;

    public DivingBootsItem(class_1793 settings) {
        super(settings);
    }

    public static boolean isWornBy(class_1297 entity) {
        return !getWornItem(entity).method_7960();
    }

    public static class_1799 getWornItem(class_1297 entity) {
        if (!(entity instanceof class_1309 livingEntity)) {
            return class_1799.field_8037;
        }
        class_1799 stack = livingEntity.method_6118(SLOT);
        if (!(stack.method_7909() instanceof DivingBootsItem)) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public static void accelerateDescentUnderwater(class_1297 entity) {
        if (!(entity instanceof class_1657 player))
            return;

        if (!affects(player))
            return;

        class_243 motion = player.method_18798();
        player.method_24830(player.method_24828() || player.field_5992);

        if (player.method_70673() && player.method_24828()) {
            motion = motion.method_1031(0, .5f, 0);
            player.method_24830(false);
        } else {
            motion = motion.method_1031(0, -0.05f, 0);
        }

        float multiplier = 1.3f;
        if (motion.method_18805(1, 0, 1).method_1033() < 0.145f && (player.field_6250 > 0 || player.field_6212 != 0) && !player.method_5715())
            motion = motion.method_18805(multiplier, 1, multiplier);
        player.method_18799(motion);
    }

    protected static boolean affects(class_1657 player) {
        boolean old = AllSynchedDatas.HEAVY_BOOTS.get(player);
        if (!isWornBy(player)) {
            if (old) {
                AllSynchedDatas.HEAVY_BOOTS.set(player, false);
            }
            return false;
        }
        if (!old) {
            AllSynchedDatas.HEAVY_BOOTS.set(player, true);
        }
        if (!player.method_5799())
            return false;
        if (player.method_18376() == class_4050.field_18079)
            return false;
        return !player.method_31549().field_7479;
    }

    public static void onLavaTravel(class_1657 player, boolean onGround) {
        class_1799 bootsStack = DivingBootsItem.getWornItem(player);
        if (!bootsStack.method_31574(AllItems.NETHERITE_DIVING_BOOTS)) {
            return;
        }
        class_243 playerVelocity = player.method_18798();
        double yMotion = playerVelocity.field_1351;
        double vMultiplier = yMotion < 0 ? Math.max(0, 2.5 - Math.abs(yMotion) * 2) : 1;
        class_243 velocity;
        if (onGround) {
            if (player.method_70673()) {
                boolean eyeInFluid = player.method_5777(class_3486.field_15518);
                vMultiplier = yMotion == 0 ? 0 : (eyeInFluid ? 1 : 0.5) / yMotion;
            }
            double hMultiplier = player.method_5624() ? 1.85 : 1.75;
            velocity = new class_243(hMultiplier, vMultiplier, hMultiplier);
        } else {
            if (yMotion > 0) {
                vMultiplier = 1.3;
            }
            velocity = new class_243(1.75, vMultiplier, 1.75);
        }
        //        if (!player.isOnGround()) {
        //            if (player.isJumping() && player.getPersistentData().contains("LavaGrounded")) {
        //                boolean eyeInFluid = player.isSubmergedIn(FluidTags.LAVA);
        //                vMultiplier = yMotion == 0 ? 0 : (eyeInFluid ? 1 : 0.5) / yMotion;
        //            } else if (yMotion > 0) {
        //                vMultiplier = 1.3;
        //            }
        //
        //            player.getPersistentData().remove("LavaGrounded");
        //            velocity = new Vec3d(1.75, vMultiplier, 1.75);
        //        } else {
        //            player.getPersistentData().putBoolean("LavaGrounded", true);
        //            double hMultiplier = player.isSprinting() ? 1.85 : 1.75;
        //            velocity = new Vec3d(hMultiplier, vMultiplier, hMultiplier);
        //        }

        player.method_18799(playerVelocity.method_18806(velocity));
    }
}
