package com.zurrtum.create.content.equipment.toolbox;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.*;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.block.*;
import net.minecraft.class_10225;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;
import java.util.function.Function;

import static net.minecraft.class_2741.field_12508;

public class ToolboxBlock extends class_2383 implements class_3737, IBE<ToolboxBlockEntity>, ItemInventoryProvider<ToolboxBlockEntity> {

    protected final class_1767 color;

    public static final MapCodec<ToolboxBlock> field_46280 = method_54094(p -> new ToolboxBlock(p, class_1767.field_7952));

    public ToolboxBlock(class_2251 properties, class_1767 color) {
        super(properties);
        this.color = color;
        method_9590(method_9564().method_11657(field_12508, false));
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, ToolboxBlockEntity blockEntity, class_2350 context) {
        return blockEntity.inventory;
    }

    public static Function<class_2251, ToolboxBlock> dyed(class_1767 color) {
        return settings -> new ToolboxBlock(settings, color);
    }

    public static ToolboxBlock getColorBlock(class_1767 color) {
        return switch (color) {
            case field_7952 -> AllBlocks.WHITE_TOOLBOX;
            case field_7946 -> AllBlocks.ORANGE_TOOLBOX;
            case field_7958 -> AllBlocks.MAGENTA_TOOLBOX;
            case field_7951 -> AllBlocks.LIGHT_BLUE_TOOLBOX;
            case field_7947 -> AllBlocks.YELLOW_TOOLBOX;
            case field_7961 -> AllBlocks.LIME_TOOLBOX;
            case field_7954 -> AllBlocks.PINK_TOOLBOX;
            case field_7944 -> AllBlocks.GRAY_TOOLBOX;
            case field_7967 -> AllBlocks.LIGHT_GRAY_TOOLBOX;
            case field_7955 -> AllBlocks.CYAN_TOOLBOX;
            case field_7945 -> AllBlocks.PURPLE_TOOLBOX;
            case field_7966 -> AllBlocks.BLUE_TOOLBOX;
            case field_7957 -> AllBlocks.BROWN_TOOLBOX;
            case field_7942 -> AllBlocks.GREEN_TOOLBOX;
            case field_7964 -> AllBlocks.RED_TOOLBOX;
            case field_7963 -> AllBlocks.BLACK_TOOLBOX;
        };
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(field_12508).method_11667(field_11177));
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (worldIn.method_8608())
            return;
        if (stack == null)
            return;
        withBlockEntityDo(
            worldIn, pos, be -> {
                be.readInventory(stack.method_58694(AllDataComponents.TOOLBOX_INVENTORY));
                if (stack.method_57826(AllDataComponents.TOOLBOX_UUID))
                    be.setUniqueId(stack.method_58694(AllDataComponents.TOOLBOX_UUID));
                if (stack.method_57826(class_9334.field_49631))
                    be.setCustomName(stack.method_7964());
            }
        );
    }

    @Override
    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (FakePlayerHandler.has(player))
            return;
        if (world.method_8608())
            return;
        withBlockEntityDo(world, pos, ToolboxBlockEntity::unequipTracked);
        if (world instanceof class_3218) {
            class_1799 cloneItemStack = method_9574(world, pos, state, true);
            withBlockEntityDo(
                world, pos, i -> {
                    cloneItemStack.method_57365(i.method_57590());
                }
            );
            world.method_22352(pos, false);
            if (world.method_8320(pos) != state)
                player.method_31548().method_7398(cloneItemStack);
        }
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        class_1799 item = new class_1799(this);
        Optional<ToolboxBlockEntity> blockEntityOptional = getBlockEntityOptional(world, pos);

        blockEntityOptional.map(tb -> item.method_57379(AllDataComponents.TOOLBOX_INVENTORY, tb.inventory));

        blockEntityOptional.map(ToolboxBlockEntity::getUniqueId).ifPresent(uid -> item.method_57379(AllDataComponents.TOOLBOX_UUID, uid));
        blockEntityOptional.map(ToolboxBlockEntity::method_5797).ifPresent(name -> item.method_57379(class_9334.field_49631, name));
        return item;
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbourState,
        class_5819 random
    ) {
        if (state.method_11654(field_12508))
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        return state;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return AllShapes.TOOLBOX.get(state.method_11654(field_11177));
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player == null || player.method_18276())
            return class_1269.field_52423;

        class_1767 color = AllItemTags.getDyeColor(stack);
        if (color != null && color != this.color) {
            if (level.method_8608())
                return class_1269.field_5812;
            class_2680 newState = BlockHelper.copyProperties(state, getColorBlock(color).method_9564());
            level.method_8501(pos, newState);
            return class_1269.field_5812;
        }

        if (FakePlayerHandler.has(player))
            return class_1269.field_52423;
        if (level.method_8608())
            return class_1269.field_5812;

        withBlockEntityDo(level, pos, toolbox -> toolbox.openHandledScreen((class_3222) player));
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_3610 ifluidstate = context.method_8045().method_8316(context.method_8037());
        return super.method_9605(context).method_11657(field_11177, context.method_8042().method_10153())
            .method_11657(field_12508, Boolean.valueOf(ifluidstate.method_15772() == class_3612.field_15910));
    }

    @Override
    public Class<ToolboxBlockEntity> getBlockEntityClass() {
        return ToolboxBlockEntity.class;
    }

    @Override
    public class_2591<? extends ToolboxBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.TOOLBOX;
    }

    public class_1767 getColor() {
        return color;
    }

    @Override
    public boolean method_9498(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2350 direction) {
        return ItemHelper.calcRedstoneFromBlockEntity(this, pLevel, pPos);
    }

    @Override
    protected @NotNull MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }
}
