package com.zurrtum.create.content.kinetics.belt.transport;

import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelControllerBlock;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelControllerBlockEntity;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class BeltCrusherInteractionHandler {
    public static boolean checkForCrushers(BeltInventory beltInventory, boolean isClient, TransportedItemStack currentItem, float nextOffset) {
        boolean beltMovementPositive = beltInventory.beltMovementPositive;
        int firstUpcomingSegment = (int) Math.floor(currentItem.beltPosition);
        int step = beltMovementPositive ? 1 : -1;
        firstUpcomingSegment = class_3532.method_15340(firstUpcomingSegment, 0, beltInventory.belt.beltLength - 1);

        for (int segment = firstUpcomingSegment; beltMovementPositive ? segment <= nextOffset : segment + 1 >= nextOffset; segment += step) {
            class_2338 crusherPos = BeltHelper.getPositionForOffset(beltInventory.belt, segment).method_10084();
            class_1937 world = beltInventory.belt.method_10997();
            class_2680 crusherState = world.method_8320(crusherPos);
            if (!(crusherState.method_26204() instanceof CrushingWheelControllerBlock))
                continue;
            class_2350 crusherFacing = crusherState.method_11654(CrushingWheelControllerBlock.field_10927);
            class_2350 movementFacing = beltInventory.belt.getMovementFacing();
            if (crusherFacing != movementFacing)
                continue;

            float crusherEntry = segment + .5f;
            crusherEntry += .399f * (beltMovementPositive ? -1 : 1);
            float postCrusherEntry = crusherEntry + .799f * (!beltMovementPositive ? -1 : 1);

            boolean hasCrossed = nextOffset > crusherEntry && nextOffset < postCrusherEntry && beltMovementPositive || nextOffset < crusherEntry && nextOffset > postCrusherEntry && !beltMovementPositive;
            if (!hasCrossed)
                return false;
            currentItem.beltPosition = crusherEntry;

            if (isClient)
                return true;
            class_2586 be = world.method_8321(crusherPos);
            if (!(be instanceof CrushingWheelControllerBlockEntity crusherBE))
                return true;

            class_1799 toInsert = currentItem.stack;
            int count = toInsert.method_7947();
            int insert = crusherBE.inventory.insert(toInsert);
            if (insert == 0) {
                return true;
            }
            if (insert == count) {
                currentItem.stack = class_1799.field_8037;
            } else {
                toInsert.method_7939(count - insert);
            }
            beltInventory.belt.notifyUpdate();
            return true;
        }

        return false;
    }
}
