package com.zurrtum.create.content.kinetics.crafter;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public record MechanicalCraftingRecipe(class_8957 raw, class_1799 result, boolean symmetrical) implements CreateRecipe<class_9694> {
    @Override
    public boolean matches(class_9694 input, class_1937 worldIn) {
        if (symmetrical)
            return raw.method_55078(input);

        // From ShapedRecipe except the symmetry
        if (input.method_59990() != raw.field_51641) {
            return false;
        }
        int width = raw.method_59995();
        if (input.method_59991() != width) {
            return false;
        }
        int height = raw.method_59996();
        if (input.method_59992() != height) {
            return false;
        }
        List<Optional<class_1856>> ingredients = raw.method_59997();
        for (int i = 0; i < height; i++) {
            for (int j = 0; j < width; j++) {
                Optional<class_1856> optional = ingredients.get(j + i * width);
                class_1799 itemStack = input.method_59985(j, i);
                if (!class_1856.method_61676(optional, itemStack)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public class_1799 craft(class_9694 craftingRecipeInput, class_7225.class_7874 wrapperLookup) {
        return result.method_7972();
    }

    @Override
    public class_3956<MechanicalCraftingRecipe> method_17716() {
        return AllRecipeTypes.MECHANICAL_CRAFTING;
    }

    @Override
    public class_1865<MechanicalCraftingRecipe> method_8119() {
        return AllRecipeSerializers.MECHANICAL_CRAFTING;
    }

    public static class Serializer implements class_1865<MechanicalCraftingRecipe> {
        public static final MapCodec<class_8957.class_8958> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_5699.method_53703(Codec.STRING.xmap(key -> key.charAt(0), String::valueOf), class_1856.field_46095).fieldOf("key")
                .forGetter(class_8957.class_8958::comp_2085), Codec.STRING.listOf().fieldOf("pattern").forGetter(class_8957.class_8958::comp_2086)
        ).apply(instance, class_8957.class_8958::new));
        public static final MapCodec<class_8957> RAW_CODEC = DATA_CODEC.flatXmap(
            class_8957::method_55080,
            recipe -> recipe.field_51640.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe"))
        );
        public static final MapCodec<MechanicalCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            RAW_CODEC.forGetter(MechanicalCraftingRecipe::raw),
            class_1799.field_24671.fieldOf("result").forGetter(MechanicalCraftingRecipe::result),
            Codec.BOOL.optionalFieldOf("accept_mirrored", false).forGetter(MechanicalCraftingRecipe::symmetrical)
        ).apply(instance, MechanicalCraftingRecipe::new));

        public static final class_9139<class_9129, MechanicalCraftingRecipe> PACKET_CODEC = class_9139.method_56436(
            class_8957.field_48359,
            MechanicalCraftingRecipe::raw,
            class_1799.field_48349,
            MechanicalCraftingRecipe::result,
            class_9135.field_48547,
            MechanicalCraftingRecipe::symmetrical,
            MechanicalCraftingRecipe::new
        );

        @Override
        public MapCodec<MechanicalCraftingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, MechanicalCraftingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}
