package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.Mode;
import org.apache.commons.lang3.tuple.MutablePair;

import java.util.UUID;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_4844;
import net.minecraft.class_6903;
import net.minecraft.class_8942;

import static com.zurrtum.create.Create.LOGGER;

public class DeployerMovingInteraction extends MovingInteractionBehaviour {

    @Override
    public boolean handlePlayerInteraction(class_1657 player, class_1268 activeHand, class_2338 localPos, AbstractContraptionEntity contraptionEntity) {
        MutablePair<class_3501, MovementContext> actor = contraptionEntity.getContraption().getActorAt(localPos);
        if (actor == null || actor.right == null)
            return false;

        MovementContext ctx = actor.right;
        class_1799 heldStack = player.method_5998(activeHand);
        if (heldStack.method_31574(AllItems.WRENCH)) {
            Mode mode = ctx.blockEntityData.method_67491("Mode", Mode.CODEC).orElse(Mode.PUNCH);
            ctx.blockEntityData.method_67494("Mode", Mode.CODEC, mode == Mode.PUNCH ? Mode.USE : Mode.PUNCH);

        } else {
            if (ctx.world.method_8608())
                return true; // we'll try again on the server side
            DeployerPlayer fake;

            if (!(ctx.temporaryData instanceof DeployerFakePlayer) && ctx.world instanceof class_3218) {
                UUID owner = ctx.blockEntityData.method_67491("Owner", class_4844.field_25122).orElse(null);
                String ownerName = ctx.blockEntityData.method_67491("Owner", Codec.STRING).orElse(null);
                DeployerPlayer deployerFakePlayer = DeployerPlayer.create((class_3218) ctx.world, owner, ownerName);
                deployerFakePlayer.setOnMinecartContraption(ctx.contraption instanceof MountedContraption);
                try (class_8942.class_11340 logging = new class_8942.class_11340(contraptionEntity.method_71370(), LOGGER)) {
                    class_2487 inventory = ctx.blockEntityData.method_67491("Inventory", class_2487.field_25128).orElseGet(class_2487::new);
                    class_11368 view = class_11352.method_71417(logging, ctx.world.method_30349(), inventory);
                    deployerFakePlayer.cast().method_31548().method_7397(view.method_71437("Inventory", class_11343.field_60354));
                }
                ctx.temporaryData = fake = deployerFakePlayer;
                ctx.blockEntityData.method_10551("Inventory");
            } else
                fake = (DeployerPlayer) ctx.temporaryData;

            if (fake == null)
                return false;

            class_3222 serverPlayer = fake.cast();
            class_1799 deployerItem = serverPlayer.method_6047();
            player.method_6122(activeHand, deployerItem.method_7972());
            serverPlayer.method_6122(class_1268.field_5808, heldStack.method_7972());
            if (!heldStack.method_7960()) {
                class_6903<class_2520> ops = player.method_56673().method_57093(class_2509.field_11560);
                ctx.blockEntityData.method_67493("HeldItem", class_1799.field_24671, ops, heldStack);
                ctx.data.method_67493("HeldItem", class_1799.field_24671, ops, heldStack);
            }
        }
        //		if (index >= 0)
        //			setContraptionActorData(contraptionEntity, index, info, ctx);
        return true;
    }
}
