package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.authlib.GameProfile;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;

public interface DeployerPlayer {
    UUID FALLBACK_ID = UUID.fromString("9e2faded-cafe-4ec2-c314-dad129ae971d");

    static DeployerPlayer create(class_3218 world, @Nullable UUID owner, @Nullable String name) {
        GameProfile profile = new GameProfile(owner == null ? FALLBACK_ID : owner, owner == null || name == null ? "Deployer" : name);
        if (FakePlayerHandler.FABRIC) {
            return new DeployerFabricFakePlayer(world, profile);
        } else {
            return new DeployerFakePlayer(world, profile);
        }
    }

    Pair<class_2338, Float> getBlockBreakingProgress();

    void setBlockBreakingProgress(Pair<class_2338, Float> blockBreakingProgress);

    class_1799 getSpawnedItemEffects();

    void setSpawnedItemEffects(class_1799 spawnedItemEffects);

    class_3225 getInteractionManager();

    boolean getPlacedTracks();

    void setPlacedTracks(boolean placedTracks);

    boolean isOnMinecartContraption();

    void setOnMinecartContraption(boolean onMinecartContraption);

    default class_3222 cast() {
        return (class_3222) this;
    }
}
