package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes.JukeboxPoint;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPoint.Mode;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2387;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2802;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4076;

public class ArmBlockEntity extends KineticBlockEntity implements TransformableBlockEntity {
    public Codec<ArmInteractionPoint> pointCodec;

    // Server
    public List<ArmInteractionPoint> inputs;
    public List<ArmInteractionPoint> outputs;
    public class_2499 interactionPointTag;

    // Both
    float chasedPointProgress;
    int chasedPointIndex;
    public class_1799 heldItem;
    public Phase phase;
    public boolean goggles;

    // Client
    ArmAngleTarget previousTarget;
    public LerpedFloat lowerArmAngle;
    public LerpedFloat upperArmAngle;
    public LerpedFloat baseAngle;
    public LerpedFloat headAngle;
    LerpedFloat clawAngle;
    float previousBaseAngle;
    boolean updateInteractionPoints;
    public int tooltipWarmup;

    protected ServerScrollOptionBehaviour<SelectionMode> selectionMode;
    protected int lastInputIndex = -1;
    protected int lastOutputIndex = -1;
    protected boolean redstoneLocked;

    public enum Phase implements class_3542 {
        SEARCH_INPUTS,
        MOVE_TO_INPUT,
        SEARCH_OUTPUTS,
        MOVE_TO_OUTPUT,
        DANCING;

        public static final Codec<Phase> CODEC = class_3542.method_28140(Phase::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public ArmBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_ARM, pos, state);
        inputs = new ArrayList<>();
        outputs = new ArrayList<>();
        interactionPointTag = null;
        heldItem = class_1799.field_8037;
        phase = Phase.SEARCH_INPUTS;
        previousTarget = ArmAngleTarget.NO_TARGET;
        baseAngle = LerpedFloat.angular();
        baseAngle.startWithValue(previousTarget.baseAngle);
        lowerArmAngle = LerpedFloat.angular();
        lowerArmAngle.startWithValue(previousTarget.lowerArmAngle);
        upperArmAngle = LerpedFloat.angular();
        upperArmAngle.startWithValue(previousTarget.upperArmAngle);
        headAngle = LerpedFloat.angular();
        headAngle.startWithValue(previousTarget.headAngle);
        clawAngle = LerpedFloat.angular();
        previousBaseAngle = previousTarget.baseAngle;
        updateInteractionPoints = true;
        redstoneLocked = false;
        tooltipWarmup = 15;
        goggles = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        selectionMode = new ServerScrollOptionBehaviour<>(SelectionMode.class, this);
        behaviours.add(selectionMode);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(
            AllAdvancements.ARM_BLAZE_BURNER,
            AllAdvancements.ARM_MANY_TARGETS,
            AllAdvancements.MECHANICAL_ARM,
            AllAdvancements.MUSICAL_ARM
        );
    }

    @Override
    public void tick() {
        super.tick();
        initInteractionPoints();
        boolean targetReached = tickMovementProgress();

        if (tooltipWarmup > 0)
            tooltipWarmup--;
        if (chasedPointProgress < 1) {
            if (phase == Phase.MOVE_TO_INPUT) {
                ArmInteractionPoint point = getTargetedInteractionPoint();
                if (point != null)
                    point.keepAlive();
            }
            return;
        }
        if (field_11863.method_8608())
            return;

        if (phase == Phase.MOVE_TO_INPUT)
            collectItem();
        else if (phase == Phase.MOVE_TO_OUTPUT)
            depositItem();
        else if (phase == Phase.SEARCH_INPUTS || phase == Phase.DANCING)
            searchForItem();

        if (targetReached)
            lazyTick();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();

        if (field_11863.method_8608())
            return;
        if (chasedPointProgress < .5f)
            return;
        if (phase == Phase.SEARCH_INPUTS || phase == Phase.DANCING)
            checkForMusic();
        if (phase == Phase.SEARCH_OUTPUTS)
            searchForDestination();
    }

    private void checkForMusic() {
        boolean hasMusic = checkForMusicAmong(inputs) || checkForMusicAmong(outputs);
        if (hasMusic != (phase == Phase.DANCING)) {
            phase = hasMusic ? Phase.DANCING : Phase.SEARCH_INPUTS;
            method_5431();
            sendData();
        }
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(3);
    }

    private boolean checkForMusicAmong(List<ArmInteractionPoint> list) {
        for (ArmInteractionPoint armInteractionPoint : list) {
            if (!(armInteractionPoint instanceof JukeboxPoint))
                continue;
            class_2680 state = field_11863.method_8320(armInteractionPoint.getPos());
            if (state.method_61767(class_2387.field_11180, false))
                return true;
        }
        return false;
    }

    private boolean tickMovementProgress() {
        boolean targetReachedPreviously = chasedPointProgress >= 1;
        chasedPointProgress += Math.min(256, Math.abs(getSpeed())) / 1024f;
        if (chasedPointProgress > 1)
            chasedPointProgress = 1;
        if (!field_11863.method_8608())
            return !targetReachedPreviously && chasedPointProgress >= 1;

        ArmInteractionPoint targetedInteractionPoint = getTargetedInteractionPoint();
        ArmAngleTarget previousTarget = this.previousTarget;
        ArmAngleTarget target = targetedInteractionPoint == null ? ArmAngleTarget.NO_TARGET : targetedInteractionPoint.getTargetAngles(
            field_11867,
            isOnCeiling()
        );

        baseAngle.setValue(AngleHelper.angleLerp(
            chasedPointProgress,
            previousBaseAngle,
            target == ArmAngleTarget.NO_TARGET ? previousBaseAngle : target.baseAngle
        ));

        // Arm's angles first backup to resting position and then continue
        if (chasedPointProgress < .5f)
            target = ArmAngleTarget.NO_TARGET;
        else
            previousTarget = ArmAngleTarget.NO_TARGET;
        float progress = chasedPointProgress == 1 ? 1 : (chasedPointProgress % .5f) * 2;

        lowerArmAngle.setValue(class_3532.method_16439(progress, previousTarget.lowerArmAngle, target.lowerArmAngle));
        upperArmAngle.setValue(class_3532.method_16439(progress, previousTarget.upperArmAngle, target.upperArmAngle));
        headAngle.setValue(AngleHelper.angleLerp(progress, previousTarget.headAngle % 360, target.headAngle % 360));

        return false;
    }

    protected boolean isOnCeiling() {
        class_2680 state = method_11010();
        return method_11002() && state.method_61767(ArmBlock.CEILING, false);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (!heldItem.method_7960())
            class_2248.method_9577(field_11863, field_11867, heldItem);
    }

    @Nullable
    private ArmInteractionPoint getTargetedInteractionPoint() {
        if (chasedPointIndex == -1)
            return null;
        if (phase == Phase.MOVE_TO_INPUT && chasedPointIndex < inputs.size())
            return inputs.get(chasedPointIndex);
        if (phase == Phase.MOVE_TO_OUTPUT && chasedPointIndex < outputs.size())
            return outputs.get(chasedPointIndex);
        return null;
    }

    protected void searchForItem() {
        if (redstoneLocked)
            return;

        boolean foundInput = false;
        // for round robin, we start looking after the last used index, for default we
        // start at 0;
        int startIndex = selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : lastInputIndex + 1;

        // if we enforce round robin, only look at the next input in the list,
        // otherwise, look at all inputs
        int scanRange = selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? lastInputIndex + 2 : inputs.size();
        if (scanRange > inputs.size())
            scanRange = inputs.size();

        InteractionPoints:
        for (int i = startIndex; i < scanRange; i++) {
            ArmInteractionPoint armInteractionPoint = inputs.get(i);
            if (!armInteractionPoint.isValid())
                continue;
            for (int j = 0; j < armInteractionPoint.getSlotCount(this); j++) {
                if (getDistributableAmount(armInteractionPoint, j) == 0)
                    continue;

                selectIndex(true, i);
                foundInput = true;
                break InteractionPoints;
            }
        }
        if (!foundInput && selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            // if we didn't find an input, but don't want to enforce round robin, reset the
            // last index
            lastInputIndex = -1;
        }
        if (lastInputIndex == inputs.size() - 1) {
            // if we reached the last input in the list, reset the last index
            lastInputIndex = -1;
        }
    }

    protected void searchForDestination() {
        class_1799 held = heldItem.method_7972();

        boolean foundOutput = false;
        // for round robin, we start looking after the last used index, for default we
        // start at 0;
        int startIndex = selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : lastOutputIndex + 1;

        // if we enforce round robin, only look at the next index in the list,
        // otherwise, look at all
        int scanRange = selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? lastOutputIndex + 2 : outputs.size();
        if (scanRange > outputs.size())
            scanRange = outputs.size();

        for (int i = startIndex; i < scanRange; i++) {
            ArmInteractionPoint armInteractionPoint = outputs.get(i);
            if (!armInteractionPoint.isValid())
                continue;

            class_1799 remainder = armInteractionPoint.insert(this, held, true);
            if (class_1799.method_7973(remainder, heldItem))
                continue;

            selectIndex(false, i);
            foundOutput = true;
            break;
        }

        if (!foundOutput && selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            // if we didn't find an input, but don't want to enforce round robin, reset the
            // last index
            lastOutputIndex = -1;
        }
        if (lastOutputIndex == outputs.size() - 1) {
            // if we reached the last input in the list, reset the last index
            lastOutputIndex = -1;
        }
    }

    // input == true => select input, false => select output
    private void selectIndex(boolean input, int index) {
        phase = input ? Phase.MOVE_TO_INPUT : Phase.MOVE_TO_OUTPUT;
        chasedPointIndex = index;
        chasedPointProgress = 0;
        if (input)
            lastInputIndex = index;
        else
            lastOutputIndex = index;
        sendData();
        method_5431();
    }

    protected int getDistributableAmount(ArmInteractionPoint armInteractionPoint, int i) {
        class_1799 stack = armInteractionPoint.extract(this, i, true);
        class_1799 remainder = simulateInsertion(stack);
        if (class_1799.method_7984(stack, remainder)) {
            return stack.method_7947() - remainder.method_7947();
        } else {
            return stack.method_7947();
        }
    }

    private class_1799 simulateInsertion(class_1799 stack) {
        for (ArmInteractionPoint armInteractionPoint : outputs) {
            if (armInteractionPoint.isValid())
                stack = armInteractionPoint.insert(this, stack, true);
            if (stack.method_7960())
                break;
        }
        return stack;
    }

    protected void depositItem() {
        ArmInteractionPoint armInteractionPoint = getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid()) {
            class_1799 toInsert = heldItem.method_7972();
            class_1799 remainder = armInteractionPoint.insert(this, toInsert, false);
            heldItem = remainder;

            if (armInteractionPoint instanceof JukeboxPoint && remainder.method_7960())
                award(AllAdvancements.MUSICAL_ARM);
        }

        phase = heldItem.method_7960() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
        chasedPointProgress = 0;
        chasedPointIndex = -1;
        sendData();
        method_5431();

        if (!field_11863.method_8608())
            award(AllAdvancements.MECHANICAL_ARM);
    }

    protected void collectItem() {
        ArmInteractionPoint armInteractionPoint = getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid())
            for (int i = 0; i < armInteractionPoint.getSlotCount(this); i++) {
                int amountExtracted = getDistributableAmount(armInteractionPoint, i);
                if (amountExtracted == 0)
                    continue;

                class_1799 prevHeld = heldItem;
                heldItem = armInteractionPoint.extract(this, i, amountExtracted, false);
                phase = Phase.SEARCH_OUTPUTS;
                chasedPointProgress = 0;
                chasedPointIndex = -1;
                sendData();
                method_5431();

                if (!class_1799.method_7984(heldItem, prevHeld))
                    field_11863.method_8396(null, field_11867, class_3417.field_15197, class_3419.field_15245, .125f, .5f + field_11863.field_9229.method_43057() * .25f);
                return;
            }

        phase = Phase.SEARCH_INPUTS;
        chasedPointProgress = 0;
        chasedPointIndex = -1;
        sendData();
        method_5431();
    }

    public void redstoneUpdate() {
        if (field_11863.method_8608())
            return;
        boolean blockPowered = field_11863.method_49803(field_11867);
        if (blockPowered == redstoneLocked)
            return;
        redstoneLocked = blockPowered;
        sendData();
        if (!redstoneLocked)
            searchForItem();
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        if (interactionPointTag == null)
            return;

        for (class_2520 tag : interactionPointTag) {
            ArmInteractionPoint.transformPos((class_2487) tag, transform);
        }

        notifyUpdate();
    }

    // ClientLevel#hasChunk (and consequently #isAreaLoaded) always returns true,
    // so manually check the ChunkSource to avoid weird behavior on the client side
    protected boolean isAreaActuallyLoaded(class_2338 center, int range) {
        if (!field_11863.method_22343(center.method_10069(-range, -range, -range), center.method_10069(range, range, range))) {
            return false;
        }
        if (field_11863.method_8608()) {
            int minY = center.method_10264() - range;
            int maxY = center.method_10264() + range;
            if (maxY < field_11863.method_31607() || minY >= field_11863.method_31600()) {
                return false;
            }

            int minX = center.method_10263() - range;
            int minZ = center.method_10260() - range;
            int maxX = center.method_10263() + range;
            int maxZ = center.method_10260() + range;

            int minChunkX = class_4076.method_18675(minX);
            int maxChunkX = class_4076.method_18675(maxX);
            int minChunkZ = class_4076.method_18675(minZ);
            int maxChunkZ = class_4076.method_18675(maxZ);

            class_2802 chunkSource = field_11863.method_8398();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    if (!chunkSource.method_12123(chunkX, chunkZ)) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected void initInteractionPoints() {
        if (!updateInteractionPoints || interactionPointTag == null)
            return;
        if (!isAreaActuallyLoaded(field_11867, getRange() + 1))
            return;
        inputs.clear();
        outputs.clear();

        boolean hasBlazeBurner = false;
        if (pointCodec == null) {
            pointCodec = ArmInteractionPoint.getCodec(field_11863, field_11867);
        }
        for (class_2520 tag : interactionPointTag) {
            ArmInteractionPoint point = decodePoint(tag);
            if (point == null)
                continue;
            class_2680 state = field_11863.method_8320(point.pos);
            if (!point.type.canCreatePoint(field_11863, point.pos, state)) {
                continue;
            }
            if (point.getMode() == Mode.DEPOSIT)
                outputs.add(point);
            else if (point.getMode() == Mode.TAKE)
                inputs.add(point);
            hasBlazeBurner |= point instanceof AllArmInteractionPointTypes.BlazeBurnerPoint;
        }

        if (!field_11863.method_8608()) {
            if (outputs.size() >= 10)
                award(AllAdvancements.ARM_MANY_TARGETS);
            if (hasBlazeBurner)
                award(AllAdvancements.ARM_BLAZE_BURNER);
        }

        updateInteractionPoints = false;
        sendData();
        method_5431();
    }

    public void writeInteractionPoints(class_11372 view) {
        if (pointCodec == null) {
            pointCodec = ArmInteractionPoint.getCodec(field_11863, field_11867);
        }
        class_2499 list;
        if (updateInteractionPoints && interactionPointTag != null) {
            list = interactionPointTag;
        } else {
            list = new class_2499();
            appendEncodedPoints(inputs, pointCodec, list);
            appendEncodedPoints(outputs, pointCodec, list);
        }
        view.method_71468("InteractionPoints", CreateCodecs.NBT_LIST_CODEC, list);
    }

    public static void appendEncodedPoints(List<ArmInteractionPoint> points, Codec<ArmInteractionPoint> pointCodec, class_2499 list) {
        for (ArmInteractionPoint point : points) {
            switch (pointCodec.encodeStart(class_2509.field_11560, point)) {
                case DataResult.Success<NbtElement> success -> list.add(success.value());
                case DataResult.Error<NbtElement> error ->
                    Create.LOGGER.warn("Failed to append value '{}' to list 'InteractionPoints': {}", point, error.message());
            }
        }
    }

    public ArmInteractionPoint decodePoint(class_2520 tag) {
        return switch (pointCodec.parse(class_2509.field_11560, tag)) {
            case DataResult.Success<ArmInteractionPoint> success -> success.value();
            case DataResult.Error<ArmInteractionPoint> error -> {
                Create.LOGGER.warn("Failed to decode value '{}' from field 'InteractionPoints': {}", tag, error.message());
                yield null;
            }
        };
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);

        writeInteractionPoints(view);

        view.method_71468("Phase", Phase.CODEC, phase);
        view.method_71472("Powered", redstoneLocked);
        view.method_71472("Goggles", goggles);
        if (!heldItem.method_7960()) {
            view.method_71468("HeldItem", class_1799.field_24671, heldItem);
        }
        view.method_71465("TargetPointIndex", chasedPointIndex);
        view.method_71464("MovementProgress", chasedPointProgress);
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);

        writeInteractionPoints(view);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        int previousIndex = chasedPointIndex;
        Phase previousPhase = phase;
        class_2499 interactionPointTagBefore = interactionPointTag;

        super.read(view, clientPacket);
        heldItem = view.method_71426("HeldItem", class_1799.field_24671).orElse(class_1799.field_8037);
        phase = view.method_71426("Phase", Phase.CODEC).orElse(Phase.SEARCH_INPUTS);
        chasedPointIndex = view.method_71424("TargetPointIndex", 0);
        chasedPointProgress = view.method_71423("MovementProgress", 0);
        interactionPointTag = view.method_71426("InteractionPoints", CreateCodecs.NBT_LIST_CODEC).orElseGet(class_2499::new);
        redstoneLocked = view.method_71433("Powered", false);

        boolean hadGoggles = goggles;
        goggles = view.method_71433("Goggles", false);

        if (!clientPacket)
            return;

        if (hadGoggles != goggles && field_11863.method_8608())
            AllClientHandle.INSTANCE.queueUpdate(this);

        boolean ceiling = isOnCeiling();
        if (interactionPointTagBefore == null || interactionPointTagBefore.size() != interactionPointTag.size())
            updateInteractionPoints = true;
        if (previousIndex != chasedPointIndex || (previousPhase != phase)) {
            ArmInteractionPoint previousPoint = null;
            if (previousPhase == Phase.MOVE_TO_INPUT && previousIndex < inputs.size())
                previousPoint = inputs.get(previousIndex);
            if (previousPhase == Phase.MOVE_TO_OUTPUT && previousIndex < outputs.size())
                previousPoint = outputs.get(previousIndex);
            previousTarget = previousPoint == null ? ArmAngleTarget.NO_TARGET : previousPoint.getTargetAngles(field_11867, ceiling);
            if (previousPoint != null)
                previousBaseAngle = previousTarget.baseAngle;

            ArmInteractionPoint targetedPoint = getTargetedInteractionPoint();
            if (targetedPoint != null)
                targetedPoint.updateCachedState();
        }
    }

    public static int getRange() {
        return AllConfigs.server().logistics.mechanicalArmRange.get();
    }

    public void setLevel(class_1937 level) {
        super.method_31662(level);
        for (ArmInteractionPoint input : inputs) {
            input.setLevel(level);
        }
        for (ArmInteractionPoint output : outputs) {
            output.setLevel(level);
        }
    }

    public enum SelectionMode {
        ROUND_ROBIN,
        FORCED_ROUND_ROBIN,
        PREFER_FIRST
    }
}
