package com.zurrtum.create.content.kinetics.simpleRelays;

import com.google.common.base.Predicates;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.decoration.encasing.EncasableBlock;
import com.zurrtum.create.content.decoration.girder.GirderEncasedShaftBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlock;
import com.zurrtum.create.foundation.placement.PoleHelper;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class ShaftBlock extends AbstractSimpleShaftBlock implements EncasableBlock {

    public static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public ShaftBlock(class_2251 properties) {
        super(properties);
    }

    public static boolean isShaft(class_2680 state) {
        return state.method_27852(AllBlocks.SHAFT);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 stateForPlacement = super.method_9605(context);
        return pickCorrectShaftType(stateForPlacement, context.method_8045(), context.method_8037());
    }

    public static class_2680 pickCorrectShaftType(class_2680 stateForPlacement, class_1937 level, class_2338 pos) {
        if (PoweredShaftBlock.stillValid(stateForPlacement, level, pos))
            return PoweredShaftBlock.getEquivalent(stateForPlacement);
        return stateForPlacement;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.SIX_VOXEL_POLE.get(state.method_11654(AXIS));
    }

    @Override
    public float getParticleTargetRadius() {
        return .35f;
    }

    @Override
    public float getParticleInitialRadius() {
        return .125f;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player.method_5715() || !player.method_7294())
            return class_1269.field_52423;

        class_1269 result = tryEncase(state, level, pos, stack, player, hand, hitResult);
        if (result.method_23665())
            return result;

        if (stack.method_31574(AllItems.METAL_GIRDER) && state.method_11654(AXIS) != class_2351.field_11052) {
            KineticBlockEntity.switchToBlockState(
                level,
                pos,
                AllBlocks.METAL_GIRDER_ENCASED_SHAFT.method_9564().method_11657(WATERLOGGED, state.method_11654(WATERLOGGED))
                    .method_11657(GirderEncasedShaftBlock.HORIZONTAL_AXIS, state.method_11654(AXIS) == class_2351.field_11051 ? class_2351.field_11051 : class_2351.field_11048)
            );
            if (!level.method_8608() && !player.method_68878()) {
                stack.method_7934(1);
                if (stack.method_7960())
                    player.method_6122(hand, class_1799.field_8037);
            }
            return class_1269.field_5812;
        }

        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(stack))
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);

        return class_1269.field_52423;
    }

    private static class PlacementHelper extends PoleHelper<class_2351> {
        // used for extending a shaft in its axis, like the piston poles. works with
        // shafts and cogs

        private PlacementHelper() {
            super(
                state -> state.method_26204() instanceof AbstractSimpleShaftBlock || state.method_26204() instanceof PoweredShaftBlock,
                state -> state.method_11654(AXIS),
                AXIS
            );
        }

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return i -> i.method_7909() instanceof class_1747 && ((class_1747) i.method_7909()).method_7711() instanceof AbstractSimpleShaftBlock;
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return Predicates.or(state -> state.method_27852(AllBlocks.SHAFT), state -> state.method_27852(AllBlocks.POWERED_SHAFT));
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful())
                offset.withTransform(offset.getTransform()
                    .andThen(s -> world.method_8608() ? s : ShaftBlock.pickCorrectShaftType(s, world, offset.getBlockPos())));
            return offset;
        }

    }
}
