package com.zurrtum.create.content.logistics.factoryBoard;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.math.VecHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.util.math.*;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class FactoryPanelConnection {
    public static final Codec<FactoryPanelConnection> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        FactoryPanelPosition.CODEC.fieldOf(
            "position").forGetter(i -> i.from),
        Codec.INT.fieldOf("amount").forGetter(i -> i.amount),
        Codec.INT.fieldOf("arrow_bending").forGetter(i -> i.arrowBendMode)
    ).apply(instance, FactoryPanelConnection::new));

    public FactoryPanelPosition from;
    public int amount;
    public List<class_2350> path;
    public int arrowBendMode;
    public boolean success;

    public WeakReference<Object> cachedSource;

    private int arrowBendModeCurrentPathUses;

    public FactoryPanelConnection(FactoryPanelPosition from, int amount) {
        this(from, amount, -1);
    }

    public FactoryPanelConnection(FactoryPanelPosition from, int amount, int arrowBendMode) {
        this.from = from;
        this.amount = amount;
        this.arrowBendMode = arrowBendMode;
        path = new ArrayList<>();
        success = true;
        arrowBendModeCurrentPathUses = 0;
        cachedSource = new WeakReference<>(null);
    }

    public List<class_2350> getPath(class_1937 level, class_2680 state, FactoryPanelPosition to, class_243 start) {
        if (!path.isEmpty() && arrowBendModeCurrentPathUses == arrowBendMode)
            return path;

        boolean findSuitable = arrowBendMode == -1;
        arrowBendModeCurrentPathUses = arrowBendMode;

        final class_243 diff = calculatePathDiff(state, to);
        final float xRot = class_3532.field_29848 * FactoryPanelBlock.getXRot(state);
        final float yRot = class_3532.field_29848 * FactoryPanelBlock.getYRot(state);

        // When mode is not locked, find one that doesnt intersect with other gauges
        ModeFinder:
        for (int actualMode = 0; actualMode <= 4; actualMode++) {
            path.clear();
            if (!findSuitable && actualMode != arrowBendMode)
                continue;
            boolean desperateOption = actualMode == 4;

            class_2338 toTravelFirst = class_2338.field_10980;
            class_2338 toTravelLast = class_2338.method_49638(diff.method_1021(2).method_1031(0.1, 0.1, 0.1));

            if (actualMode > 1) {
                boolean flipX = diff.field_1352 > 0 ^ (actualMode % 2 == 1);
                boolean flipZ = diff.field_1350 > 0 ^ (actualMode % 2 == 0);
                int ceilX = class_3532.method_38788(toTravelLast.method_10263(), 2);
                int ceilZ = class_3532.method_38788(toTravelLast.method_10260(), 2);
                int floorZ = class_3532.method_48116(toTravelLast.method_10260(), 2);
                int floorX = class_3532.method_48116(toTravelLast.method_10263(), 2);
                toTravelFirst = new class_2338(flipX ? floorX : ceilX, 0, flipZ ? floorZ : ceilZ);
                toTravelLast = new class_2338(!flipX ? floorX : ceilX, 0, !flipZ ? floorZ : ceilZ);
            }

            class_2350 lastDirection = null;
            class_2350 currentDirection = null;

            for (class_2338 toTravel : List.of(toTravelFirst, toTravelLast)) {
                boolean zIsFarther = Math.abs(toTravel.method_10260()) > Math.abs(toTravel.method_10263());
                boolean zIsPreferred = desperateOption ? zIsFarther : actualMode % 2 == 1;
                List<class_2350> directionOrder = zIsPreferred ? List.of(class_2350.field_11035, class_2350.field_11043, class_2350.field_11039, class_2350.field_11034) : List.of(class_2350.field_11039,
                    class_2350.field_11034,
                    class_2350.field_11035,
                    class_2350.field_11043
                );

                for (int i = 0; i < 100; i++) {
                    if (toTravel.equals(class_2338.field_10980))
                        break;

                    for (class_2350 d : directionOrder) {
                        if (lastDirection != null && d == lastDirection.method_10153())
                            continue;
                        if (currentDirection == null || toTravel.method_10093(d).method_19455(class_2338.field_10980) < toTravel.method_10093(currentDirection)
                            .method_19455(class_2338.field_10980))
                            currentDirection = d;
                    }

                    lastDirection = currentDirection;
                    toTravel = toTravel.method_10093(currentDirection);
                    path.add(currentDirection);
                }
            }

            if (findSuitable && !desperateOption) {
                class_2338 travelled = class_2338.field_10980;
                for (int i = 0; i < path.size() - 1; i++) {
                    class_2350 d = path.get(i);
                    travelled = travelled.method_10093(d);
                    class_243 testOffset = class_243.method_24954(travelled).method_1021(0.5);
                    testOffset = VecHelper.rotate(testOffset, 180, class_2351.field_11052);
                    testOffset = VecHelper.rotate(testOffset, xRot + 90, class_2351.field_11048);
                    testOffset = VecHelper.rotate(testOffset, yRot, class_2351.field_11052);
                    class_243 v = start.method_1019(testOffset);
                    if (!isSpaceEmpty(level, new class_238(v, v).method_1014(1 / 128f)))
                        continue ModeFinder;
                }
            }

            break;
        }

        return path;
    }

    private static boolean isSpaceEmpty(class_1937 world, class_238 box) {
        for (class_265 voxelShape : world.method_20812(null, box)) {
            if (!voxelShape.method_1110()) {
                return false;
            }
        }
        return world.method_20743(null, box).isEmpty();
    }

    public class_243 calculatePathDiff(class_2680 state, FactoryPanelPosition to) {
        float xRot = class_3532.field_29848 * FactoryPanelBlock.getXRot(state);
        float yRot = class_3532.field_29848 * FactoryPanelBlock.getYRot(state);
        int slotDiffx = to.slot().xOffset - from.slot().xOffset;
        int slotDiffY = to.slot().yOffset - from.slot().yOffset;

        class_243 diff = class_243.method_24954(to.pos().method_10059(from.pos()));
        diff = VecHelper.rotate(diff, -yRot, class_2351.field_11052);
        diff = VecHelper.rotate(diff, -xRot - 90, class_2351.field_11048);
        diff = VecHelper.rotate(diff, -180, class_2351.field_11052);
        diff = diff.method_1031(slotDiffx * .5, 0, slotDiffY * .5);
        diff = diff.method_18805(1, 0, 1);
        return diff;
    }

}
