package com.zurrtum.create.content.logistics.funnel;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public abstract class FunnelBlock extends AbstractDirectionalFunnelBlock {

    public static final class_2746 EXTRACTING = class_2746.method_11825("extracting");

    public FunnelBlock(class_2251 p_i48415_1_) {
        super(p_i48415_1_);
        method_9590(method_9564().method_11657(EXTRACTING, false));
    }

    public abstract class_2680 getEquivalentBeltFunnel(class_1922 world, class_2338 pos, class_2680 state);

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);

        boolean sneak = context.method_8036() != null && context.method_8036().method_5715();
        state = state.method_11657(EXTRACTING, !sneak);

        for (class_2350 direction : context.method_7718()) {
            class_2680 blockstate = state.method_11657(FACING, direction.method_10153());
            if (blockstate.method_26184(context.method_8045(), context.method_8037()))
                return blockstate.method_11657(POWERED, state.method_11654(POWERED));
        }

        return state;
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(EXTRACTING));
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        boolean shouldntInsertItem = stack.method_31574(AllItems.MECHANICAL_ARM) || !canInsertIntoFunnel(state);

        if (stack.method_31574(AllItems.WRENCH))
            return class_1269.field_52423;

        if (hitResult.method_17780() == getFunnelFacing(state) && !shouldntInsertItem) {
            if (!level.method_8608())
                withBlockEntityDo(
                    level, pos, be -> {
                        class_1799 toInsert = stack.method_7972();
                        class_1799 remainder = tryInsert(level, pos, toInsert, false);
                        if (!class_1799.method_7973(remainder, toInsert) || remainder.method_7947() != stack.method_7947())
                            player.method_6122(hand, remainder);
                    }
                );
            return class_1269.field_5812;
        }

        return class_1269.field_52423;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        if (!world.method_8608())
            world.method_8501(context.method_8037(), state.method_28493(EXTRACTING));
        return class_1269.field_5812;
    }

    @Override
    public void method_9548(class_2680 state, class_1937 worldIn, class_2338 pos, class_1297 entityIn, class_10774 handler, boolean bl) {
        if (worldIn.method_8608())
            return;
        class_1799 stack = ItemHelper.fromItemEntity(entityIn);
        if (stack.method_7960())
            return;
        if (!canInsertIntoFunnel(state))
            return;

        class_2350 direction = getFunnelFacing(state);
        class_243 openPos = VecHelper.getCenterOf(pos).method_1019(class_243.method_24954(direction.method_62675()).method_1021(entityIn instanceof class_1542 ? -.25f : -.125f));
        class_243 diff = entityIn.method_73189().method_1020(openPos);
        double projectedDiff = direction.method_10166().method_10172(diff.field_1352, diff.field_1351, diff.field_1350);
        if (projectedDiff < 0 == (direction.method_10171() == class_2352.field_11056))
            return;
        float yOffset = direction == class_2350.field_11036 ? 0.25f : -0.5f;
        ServerFilteringBehaviour filter = BlockEntityBehaviour.get(worldIn, pos, ServerFilteringBehaviour.TYPE);
        if (filter.test(stack) && !PackageEntity.centerPackage(entityIn, openPos.method_1031(0, yOffset, 0)))
            return;

        class_1799 remainder = tryInsert(worldIn, pos, stack, false);
        if (remainder.method_7960())
            entityIn.method_31472();
        if (remainder.method_7947() < stack.method_7947() && entityIn instanceof class_1542)
            ((class_1542) entityIn).method_6979(remainder);
    }

    protected boolean canInsertIntoFunnel(class_2680 state) {
        return !state.method_11654(POWERED) && !state.method_11654(EXTRACTING);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = state.method_11654(FACING);
        return facing == class_2350.field_11033 ? AllShapes.FUNNEL_CEILING : facing == class_2350.field_11036 ? AllShapes.FUNNEL_FLOOR : AllShapes.FUNNEL_WALL.get(
            facing);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (context instanceof class_3727 && ((class_3727) context).method_32480() instanceof class_1542 && getFacing(state).method_10166()
            .method_10179())
            return AllShapes.FUNNEL_COLLISION.get(getFacing(state));
        return method_9530(state, world, pos, context);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 p_196271_6_,
        class_2680 p_196271_3_,
        class_5819 random
    ) {
        updateWater(world, tickView, state, pos);
        if (getFacing(state).method_10166().method_10178() || direction != class_2350.field_11033)
            return state;
        class_2680 equivalentFunnel = ProperWaterloggedBlock.withWater(world, getEquivalentBeltFunnel(null, null, state), pos);
        if (BeltFunnelBlock.isOnValidBelt(equivalentFunnel, world, pos))
            return equivalentFunnel.method_11657(
                BeltFunnelBlock.SHAPE,
                BeltFunnelBlock.getShapeForPosition(world, pos, getFacing(state), state.method_11654(EXTRACTING))
            );
        return state;
    }

}
