package com.zurrtum.create.content.logistics.packagePort.postbox;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.trains.station.GlobalPackagePort;
import com.zurrtum.create.content.trains.station.GlobalStation;
import java.lang.ref.WeakReference;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1752;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class PostboxBlockEntity extends PackagePortBlockEntity {

    public WeakReference<GlobalStation> trackedGlobalStation;

    public LerpedFloat flag;
    public boolean forceFlag;

    private boolean sendParticles;

    //TODO
    //    public AbstractComputerBehaviour computerBehaviour;

    public PostboxBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.PACKAGE_POSTBOX, pos, state);
        trackedGlobalStation = new WeakReference<>(null);
        flag = LerpedFloat.linear().startWithValue(0);
    }

    //TODO
    //    @Override
    //    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    //        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    //        super.addBehaviours(behaviours);
    //    }

    @Override
    public void tick() {
        super.tick();
        if (!field_11863.method_8608() && !isVirtual()) {
            if (sendParticles)
                sendData();
            return;
        }

        float currentTarget = flag.getChaseTarget();
        if (currentTarget == 0 || flag.settled()) {
            int target = (inventory.method_5442() && !forceFlag) ? 0 : 1;
            if (target != currentTarget) {
                flag.chase(target, 0.1f, Chaser.LINEAR);
                if (target == 1)
                    AllSoundEvents.CONTRAPTION_ASSEMBLE.playAt(field_11863, field_11867, 1, 2, true);
            }
        }
        boolean settled = flag.getValue() > .15f;
        flag.tickChaser();
        if (currentTarget == 0 && settled != flag.getValue() > .15f)
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playAt(field_11863, field_11867, 0.75f, 1.5f, true);

        if (sendParticles) {
            sendParticles = false;
            class_1752.method_7721(field_11863, field_11867, 40);
        }
    }

    @Override
    protected void onOpenChange(boolean open) {
        field_11863.method_8501(field_11867, method_11010().method_11657(PostboxBlock.OPEN, open));
        field_11863.method_45447(null, field_11867, open ? class_3417.field_17604 : class_3417.field_17603, class_3419.field_15245);
    }

    public void spawnParticles() {
        sendParticles = true;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket && sendParticles)
            view.method_71472("Particles", true);
        sendParticles = false;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        sendParticles = clientPacket && view.method_71433("Particles", false);
    }

    @Override
    public void method_5431() {
        saveOfflineBuffer();
        super.method_5431();
    }

    private void saveOfflineBuffer() {
        if (field_11863 == null || field_11863.method_8608()) {
            return;
        }
        GlobalStation station = trackedGlobalStation.get();
        if (station == null) {
            return;
        }
        GlobalPackagePort globalPackagePort = station.connectedPorts.get(field_11867);
        if (globalPackagePort == null) {
            return;
        }
        globalPackagePort.saveOfflineBuffer(inventory);
    }

    //TODO
    //    @Override
    //    public void invalidate() {
    //        super.invalidate();
    //        computerBehaviour.removePeripheral();
    //    }
}