package com.zurrtum.create.content.logistics.tableCloth;

import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_3965;

public class ServerTableClothFilteringBehaviour extends ServerFilteringBehaviour {
    public ServerTableClothFilteringBehaviour(SmartBlockEntity be) {
        super(be);
        withPredicate(is -> !(is.method_7909() instanceof FilterItem) && !(is.method_7909() instanceof ShoppingListItem));
        count = 1;
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        super.onShortInteract(player, hand, side, hitResult);
    }

    private TableClothBlockEntity dbe() {
        return (TableClothBlockEntity) blockEntity;
    }

    @Override
    public boolean mayInteract(class_1657 player) {
        return dbe().owner == null || player.method_5667().equals(dbe().owner);
    }

    @Override
    public boolean isSafeNBT() {
        return false;
    }

    public boolean isCountVisible() {
        return !filter.isEmpty();
    }

    @Override
    public boolean setFilter(class_1799 stack) {
        int before = count;
        boolean result = super.setFilter(stack);
        count = before;
        return result;
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings settings, boolean ctrlDown) {
        if (getValueSettings().equals(settings))
            return;
        count = Math.max(1, settings.value());
        blockEntity.method_5431();
        blockEntity.sendData();
        playFeedbackSound(this);
    }

    @Override
    public boolean isActive() {
        return dbe().isShop();
    }
}
