package com.zurrtum.create.content.trains.bogey;

import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.AllSoundEvents;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;

public class BogeyStyle {
    public final class_2960 id;
    public final class_2960 cycleGroup;
    public final class_2561 displayName;
    public final Supplier<class_3414> soundEvent;
    public final class_2394 contactParticle;
    public final class_2394 smokeParticle;
    public final class_2487 defaultData;
    private final Map<BogeySize, AbstractBogeyBlock<?>> sizes;

    public BogeyStyle(
        class_2960 id,
        class_2960 cycleGroup,
        class_2561 displayName,
        Supplier<class_3414> soundEvent,
        class_2394 contactParticle,
        class_2394 smokeParticle,
        class_2487 defaultData,
        Map<BogeySize, AbstractBogeyBlock<?>> sizes
    ) {
        this.id = id;
        this.cycleGroup = cycleGroup;
        this.displayName = displayName;
        this.soundEvent = soundEvent;
        this.contactParticle = contactParticle;
        this.smokeParticle = smokeParticle;
        this.defaultData = defaultData;
        this.sizes = sizes;
    }

    public Map<class_2960, BogeyStyle> getCycleGroup() {
        return AllBogeyStyles.getCycleGroup(cycleGroup);
    }

    public Set<BogeySize> validSizes() {
        return sizes.keySet();
    }

    public AbstractBogeyBlock<?> getBlockForSize(BogeySize size) {
        return sizes.get(size);
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    public AbstractBogeyBlock<?> getNextBlock(BogeySize currentSize) {
        return Stream.iterate(currentSize.nextBySize(), BogeySize::nextBySize).filter(sizes::containsKey).findFirst().map(this::getBlockForSize)
            .orElse((AbstractBogeyBlock) getBlockForSize(currentSize));
    }

    public static class Builder {
        protected final class_2960 id;
        protected final class_2960 cycleGroup;
        protected final Map<BogeySize, AbstractBogeyBlock<?>> sizes = new LinkedHashMap<>();

        protected class_2561 displayName = class_2561.method_43471("create.bogey.style.invalid");
        protected Supplier<class_3414> soundEvent = AllSoundEvents.TRAIN2::getMainEvent;
        protected class_2394 contactParticle = class_2398.field_11205;
        protected class_2394 smokeParticle = class_2398.field_11203;
        protected class_2487 defaultData = new class_2487();

        public Builder(class_2960 id, class_2960 cycleGroup) {
            this.id = id;
            this.cycleGroup = cycleGroup;
        }

        public Builder displayName(class_2561 displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder soundEvent(Supplier<class_3414> soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        public Builder contactParticle(class_2394 contactParticle) {
            this.contactParticle = contactParticle;
            return this;
        }

        public Builder smokeParticle(class_2394 smokeParticle) {
            this.smokeParticle = smokeParticle;
            return this;
        }

        public Builder defaultData(class_2487 defaultData) {
            this.defaultData = defaultData;
            return this;
        }

        public Builder size(BogeySize size, AbstractBogeyBlock<?> block) {
            this.sizes.put(size, block);
            return this;
        }

        public BogeyStyle build() {
            BogeyStyle entry = new BogeyStyle(id, cycleGroup, displayName, soundEvent, contactParticle, smokeParticle, defaultData, sizes);
            AllBogeyStyles.BOGEY_STYLES.put(id, entry);
            AllBogeyStyles.CYCLE_GROUPS.computeIfAbsent(cycleGroup, l -> new HashMap<>()).put(id, entry);
            return entry;
        }
    }
}
