package com.zurrtum.create.content.trains.bogey;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllTrackMaterials;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4538;

public class StandardBogeyBlock extends AbstractBogeyBlock<StandardBogeyBlockEntity> implements IBE<StandardBogeyBlockEntity>, ProperWaterloggedBlock, SpecialBlockItemRequirement {

    public StandardBogeyBlock(class_2251 props, BogeySize size) {
        super(props, size);
        method_9590(method_9564().method_11657(WATERLOGGED, false));
    }

    public static StandardBogeyBlock small(class_2251 props) {
        return new StandardBogeyBlock(props, AllBogeySizes.SMALL);
    }

    public static StandardBogeyBlock large(class_2251 props) {
        return new StandardBogeyBlock(props, AllBogeySizes.LARGE);
    }

    @Override
    public class_2960 getTrackType(BogeyStyle style) {
        return AllTrackMaterials.ANDESITE.getId();
    }

    @Override
    public double getWheelPointSpacing() {
        return 2;
    }

    @Override
    public double getWheelRadius() {
        return (size == AllBogeySizes.LARGE ? 12.5 : 6.5) / 16d;
    }

    @Override
    public class_243 getConnectorAnchorOffset() {
        return new class_243(0, 7 / 32f, 1);
    }

    @Override
    public BogeyStyle getDefaultStyle() {
        return AllBogeyStyles.STANDARD;
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.RAILWAY_CASING.method_7854();
    }

    @Override
    public Class<StandardBogeyBlockEntity> getBlockEntityClass() {
        return StandardBogeyBlockEntity.class;
    }

    @Override
    public class_2591<? extends StandardBogeyBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.BOGEY;
    }

}
