package com.zurrtum.create.content.trains.signal;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.signal.SignalBlock.SignalType;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Locale;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3542;

public class SignalBlockEntity extends SmartBlockEntity implements TransformableBlockEntity {

    public enum OverlayState implements class_3542 {
        RENDER,
        SKIP,
        DUAL;
        public static final Codec<OverlayState> CODEC = class_3542.method_28140(OverlayState::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public enum SignalState implements class_3542 {
        RED,
        YELLOW,
        GREEN,
        INVALID;

        public static final Codec<SignalState> CODEC = class_3542.method_28140(SignalState::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }

        public boolean isRedLight(float renderTime) {
            return this == RED || this == INVALID && renderTime % 40 < 3;
        }

        public boolean isYellowLight(float renderTime) {
            return this == YELLOW;
        }

        public boolean isGreenLight(float renderTime) {
            return this == GREEN;
        }
    }

    public TrackTargetingBehaviour<SignalBoundary> edgePoint;

    private SignalState state;
    private OverlayState overlay;
    private int switchToRedAfterTrainEntered;
    private boolean lastReportedPower;

    public SignalBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TRACK_SIGNAL, pos, state);
        this.state = SignalState.INVALID;
        this.overlay = OverlayState.SKIP;
        this.lastReportedPower = false;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71468("State", SignalState.CODEC, state);
        view.method_71468("Overlay", OverlayState.CODEC, overlay);
        view.method_71472("Power", lastReportedPower);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        state = view.method_71426("State", SignalState.CODEC).orElse(SignalState.RED);
        overlay = view.method_71426("Overlay", OverlayState.CODEC).orElse(OverlayState.RENDER);
        lastReportedPower = view.method_71433("Power", false);
        invalidateRenderBoundingBox();
    }

    @Nullable
    public SignalBoundary getSignal() {
        return edgePoint.getEdgePoint();
    }

    public boolean isPowered() {
        return state == SignalState.RED;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        edgePoint = new TrackTargetingBehaviour<>(this, EdgePointType.SIGNAL);
        behaviours.add(edgePoint);
    }

    @Override
    public void tick() {
        super.tick();
        if (field_11863.method_8608())
            return;

        SignalBoundary boundary = getSignal();
        if (boundary == null) {
            enterState(SignalState.INVALID);
            setOverlay(OverlayState.RENDER);
            return;
        }

        class_2680 blockState = method_11010();

        blockState.method_28500(SignalBlock.POWERED).ifPresent(powered -> {
            if (lastReportedPower == powered)
                return;
            lastReportedPower = powered;
            boundary.updateBlockEntityPower(this);
            notifyUpdate();
        });

        blockState.method_28500(SignalBlock.TYPE).ifPresent(stateType -> {
            SignalType targetType = boundary.getTypeFor(field_11867);
            if (stateType != targetType) {
                field_11863.method_8652(field_11867, blockState.method_11657(SignalBlock.TYPE, targetType), class_2248.field_31036);
                refreshBlockState();
            }
        });

        enterState(boundary.getStateFor(field_11867));
        setOverlay(boundary.getOverlayFor(field_11867));
    }

    public boolean getReportedPower() {
        return lastReportedPower;
    }

    public SignalState getState() {
        return state;
    }

    public OverlayState getOverlay() {
        return overlay;
    }

    public void setOverlay(OverlayState state) {
        if (this.overlay == state)
            return;
        this.overlay = state;
        notifyUpdate();
    }

    public void enterState(SignalState state) {
        if (switchToRedAfterTrainEntered > 0)
            switchToRedAfterTrainEntered--;
        if (this.state == state)
            return;
        if (state == SignalState.RED && switchToRedAfterTrainEntered > 0)
            return;
        this.state = state;
        switchToRedAfterTrainEntered = state == SignalState.GREEN || state == SignalState.YELLOW ? 15 : 0;
        notifyUpdate();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(class_243.method_24954(field_11867), class_243.method_24954(edgePoint.getGlobalPosition())).method_1014(2);
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        edgePoint.transform(be, transform);
    }

}
