package com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue;

import com.zurrtum.create.content.redstone.diodes.BrassDiodeBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class ServerBrassDiodeScrollValueBehaviour extends ServerScrollValueBehaviour {
    private static final int TICK = 20;
    private static final int MAX_COUNT = 60;
    private static final int MINUTE = MAX_COUNT * TICK;

    public ServerBrassDiodeScrollValueBehaviour(SmartBlockEntity be) {
        super(be);
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        if (getWorld().method_8608())
            return;
        class_2680 blockState = blockEntity.method_11010();
        if (blockState.method_26204() instanceof BrassDiodeBlock bdb)
            bdb.toggle(getWorld(), getPos(), blockState, player, hand);
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings valueSetting, boolean ctrlHeld) {
        int value = valueSetting.value();
        int multiplier = switch (valueSetting.row()) {
            case 0 -> 1;
            case 1 -> 20;
            default -> 60 * 20;
        };
        if (!valueSetting.equals(getValueSettings()))
            playFeedbackSound(this);
        setValue(Math.max(2, Math.max(1, value) * multiplier));
    }

    @Override
    public ValueSettings getValueSettings() {
        int row = 0;
        int value = this.value;

        if (value > 60 * 20) {
            value = value / (60 * 20);
            row = 2;
        } else if (value > 60) {
            value = value / 20;
            row = 1;
        }

        return new ValueSettings(row, value);
    }

    @Override
    public String getClipboardKey() {
        return "Timings";
    }
}
