/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zurrtum.create.catnip.config.Builder;

public abstract class ConfigValue<T> {
    private final Builder builder;
    private final T defaultValue;
    private JsonObject object;
    private T value;

    ConfigValue(Builder builder, JsonObject parent, String name, T def) {
        this.builder = builder;
        this.defaultValue = def;
        this.object = parent.getAsJsonObject(name);
        if (this.object == null) {
            this.object = new JsonObject();
            builder.addComments(this.object);
            this.set(this.defaultValue);
            parent.add(name, (JsonElement)this.object);
        } else {
            builder.addComments(this.object);
            this.read();
        }
    }

    public T get() {
        return this.value;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public void set(T value) {
        this.value = value;
        this.object.add("value", Builder.GSON.toJsonTree(value));
    }

    public void read() {
        JsonElement element = this.object.get("value");
        if (element == null) {
            this.set(this.defaultValue);
        } else {
            this.value = Builder.GSON.fromJson(element, this.defaultValue.getClass());
        }
    }

    public void save() {
        this.builder.save();
    }
}

