/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.bell;

import com.zurrtum.create.client.content.equipment.bell.SoulPulseEffect;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

@Environment(value=EnvType.CLIENT)
public class SoulPulseEffectHandler {
    private final List<SoulPulseEffect> pulses = new ArrayList<SoulPulseEffect>();
    private final Set<class_2338> occupied = new HashSet<class_2338>();

    public void tick(class_1937 world) {
        for (SoulPulseEffect pulse : this.pulses) {
            List<class_2338> spawns = pulse.tick(world);
            if (spawns == null) continue;
            if (pulse.canOverlap()) {
                for (class_2338 pos : spawns) {
                    pulse.spawnParticles(world, pos);
                }
                continue;
            }
            for (class_2338 pos : spawns) {
                if (this.occupied.contains(pos)) continue;
                pulse.spawnParticles(world, pos);
                pulse.added.add(pos);
                this.occupied.add(pos);
            }
        }
        for (SoulPulseEffect pulse : this.pulses) {
            if (!pulse.finished() || pulse.canOverlap()) continue;
            this.occupied.removeAll(pulse.added);
        }
        this.pulses.removeIf(SoulPulseEffect::finished);
    }

    public void addPulse(SoulPulseEffect pulse) {
        this.pulses.add(pulse);
    }

    public void refresh() {
        this.pulses.clear();
        this.occupied.clear();
    }
}

