/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.tableCloth;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class TableClothRenderer
extends SmartBlockEntityRenderer<TableClothBlockEntity, TableClothRenderState> {
    public TableClothRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public TableClothRenderState createRenderState() {
        return new TableClothRenderState();
    }

    @Override
    public void updateRenderState(TableClothBlockEntity be, TableClothRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        List<class_1799> stacks;
        int size;
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        state.radians = (float)Math.PI / 180 * (180.0f - be.facing.method_10144());
        if (be.isShop()) {
            state.layer = class_1921.method_23581();
            state.shop = CachedBuffers.partial(be.sideOccluded ? AllPartialModels.TABLE_CLOTH_PRICE_TOP : AllPartialModels.TABLE_CLOTH_PRICE_SIDE, state.field_62674);
        }
        if ((size = (stacks = be.getItemsForRender()).size()) == 0) {
            return;
        }
        state.items = new DepotRenderer.DepotOutputItemState[size];
        DepotRenderer.DepotOutputItemState[] items = state.items;
        class_1937 world = be.method_10997();
        for (int i = 0; i < size; ++i) {
            items[i] = DepotRenderer.DepotOutputItemState.create(this.itemModelManager, stacks.get(i), world);
        }
        state.itemPosition = class_243.method_24953((class_2382)state.field_62673);
    }

    @Override
    public void render(TableClothRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        DepotRenderer.DepotOutputItemState[] items;
        super.render(state, matrices, queue, cameraState);
        if (state.shop != null) {
            queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
        }
        if ((items = state.items) != null) {
            matrices.method_49278((Quaternionfc)new Quaternionf().setAngleAxis(state.radians, 0.0f, 1.0f, 0.0f), 0.5f, 0.5f, 0.5f);
            int size = items.length;
            boolean multiple = size > 1;
            for (int i = 0; i < size; ++i) {
                matrices.method_46416(0.5f, 0.1875f, 0.5f);
                if (multiple) {
                    matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)i * (360.0f / (float)size) + 45.0f));
                    matrices.method_46416(0.0f, i % 2 == 0 ? -0.005f : 0.0f, 0.3125f);
                    matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)(-i) * (360.0f / (float)size) - 45.0f));
                }
                DepotRenderer.DepotOutputItemState item = items[i];
                DepotRenderer.renderItem(queue, matrices, state.field_62676, item.state(), 0, item.upright(), item.box(), item.count(), null, state.itemPosition, cameraState.field_63078, true, (stack, blockItem) -> {
                    if (!blockItem.booleanValue()) {
                        stack.rotate(-state.radians + (float)Math.PI, class_2350.field_11036);
                    }
                });
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TableClothRenderState
    extends SmartBlockEntityRenderer.SmartRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer shop;
        public float radians;
        public DepotRenderer.DepotOutputItemState[] items;
        public class_243 itemPosition;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.shop.rotateCentered(this.radians, class_2350.field_11036);
            this.shop.light(this.field_62676);
            this.shop.overlay(class_4608.field_21444);
            this.shop.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

